/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.shrooms;

import com.progwml6.natura.Natura;
import com.progwml6.natura.library.NaturaRegistry;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.glowshroom.BaseGlowshroomGenerator;
import com.progwml6.natura.world.worldgen.glowshroom.nether.BlueGlowshroomGenerator;
import com.progwml6.natura.world.worldgen.glowshroom.nether.GreenGlowshroomGenerator;
import com.progwml6.natura.world.worldgen.glowshroom.nether.PurpleGlowshroomGenerator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import slimeknights.mantle.block.EnumBlock;

public class BlockNetherGlowshroom
extends BlockMushroom {
    public static PropertyEnum<GlowshroomType> TYPE = PropertyEnum.func_177709_a((String)"type", GlowshroomType.class);

    public BlockNetherGlowshroom() {
        this.func_149647_a((CreativeTabs)NaturaRegistry.tabWorld);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            IBlockState currentState = worldIn.func_180495_p(pos);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, currentState)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            currentState = worldIn.func_180495_p(pos);
            if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, currentState)) {
                worldIn.func_180501_a(blockpos1, currentState, 3);
            }
        }
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, @Nonnull List<ItemStack> list) {
        for (GlowshroomType type : GlowshroomType.values()) {
            list.add(new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)))));
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            return iblockstate.func_177230_c() == Blocks.field_150391_bh || iblockstate.func_177230_c() == Blocks.field_150424_aL || iblockstate.func_177230_c() == Blocks.field_150425_aM || iblockstate.func_177230_c() == NaturaNether.netherTaintedSoil ? true : worldIn.func_175699_k(pos) < 13 && iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= GlowshroomType.values().length) {
            meta = 0;
        }
        GlowshroomType type = GlowshroomType.values()[meta];
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((GlowshroomType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176485_d(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BaseGlowshroomGenerator gen = new BaseGlowshroomGenerator();
        switch ((GlowshroomType)((Object)state.func_177229_b(TYPE))) {
            case GREEN: {
                IBlockState glowshroom = NaturaNether.netherLargeGreenGlowshroom.func_176223_P();
                gen = new GreenGlowshroomGenerator(glowshroom);
                break;
            }
            case BLUE: {
                IBlockState glowshroom = NaturaNether.netherLargeBlueGlowshroom.func_176223_P();
                gen = new BlueGlowshroomGenerator(glowshroom);
                break;
            }
            case PURPLE: {
                IBlockState glowshroom = NaturaNether.netherLargePurpleGlowshroom.func_176223_P();
                gen = new PurpleGlowshroomGenerator(glowshroom);
                break;
            }
            default: {
                Natura.log.warn("BlockNetherGlowshroom Warning: Invalid meta, " + state.func_177229_b(TYPE) + ". Please report!");
            }
        }
        worldIn.func_175698_g(pos);
        gen.generateShroom(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
            return false;
        }
        return true;
    }

    public static enum GlowshroomType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        GREEN,
        BLUE,
        PURPLE;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

