/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import shetiphian.core.asm.Hooks;
import shetiphian.core.asm.TweakPlugin;

public class ClassTransformer
implements IClassTransformer {
    protected final Logger log = LogManager.getLogger((String)"ShetiPhian-ASM");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.entity.Entity")) {
            return this.transform(0, basicClass);
        }
        return basicClass;
    }

    private byte[] transform(int index, byte[] basicClass) {
        try {
            ClassReader reader = new ClassReader(basicClass);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            boolean transformed = false;
            switch (index) {
                case 0: {
                    this.log.info("Attempting: Injection of Run Particle Override into Entity.createRunningParticles");
                    transformed = this.transformEntity(node);
                }
            }
            if (transformed) {
                ClassWriter writer = new ClassWriter(3);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basicClass;
    }

    private boolean transformEntity(ClassNode node) {
        String ENTITY_PARTICLE = TweakPlugin.runtimeDeobfEnabled ? "func_174808_Z" : "createRunningParticles";
        String ENTITY_PARTICLE_DESC = TweakPlugin.runtimeDeobfEnabled ? "()V" : "()V";
        String HOOK = TweakPlugin.runtimeDeobfEnabled ? "(Lnet/minecraft/entity/Entity;)Z" : "(Lnet/minecraft/entity/Entity;)Z";
        this.log.info("Searching for: Entity.createRunningParticles (" + ENTITY_PARTICLE + ")");
        for (MethodNode method : node.methods) {
            if (!method.name.equals(ENTITY_PARTICLE) || !method.desc.equals(ENTITY_PARTICLE_DESC)) continue;
            this.log.info("Found Method: Entity.createRunningParticles");
            AbstractInsnNode targetNode = null;
            AbstractInsnNode popNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() == 25 && targetNode == null && ((VarInsnNode)instruction).var == 0 && instruction.getNext().getOpcode() == 180) {
                    targetNode = instruction;
                }
                if (instruction.getOpcode() != 177) continue;
                popNode = instruction;
            }
            if (targetNode != null && popNode != null) {
                this.log.info("Injecting: Run Particle Override");
                LabelNode newLabelNode = new LabelNode();
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "entityRunParticles", HOOK, false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, newLabelNode));
                method.instructions.insertBefore(targetNode, toInsert);
                method.instructions.insertBefore(popNode, (AbstractInsnNode)newLabelNode);
                return true;
            }
            this.log.info("Injection Failed");
        }
        return false;
    }
}

