/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxConnection;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static boolean isFluxItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IFluxContainerItem) {
            return true;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return true;
        }
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static int getEnergyStored(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.func_77973_b()).getEnergyStored(stack);
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return 0;
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack);
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
        }
        return 0;
    }

    public static int insertFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.func_77973_b()).receiveEnergy(stack, energy, simulate);
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, energy, simulate);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static boolean isFluxReceiver(TileEntity tile, EnumFacing facing) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluxReceiver && ((IFluxReceiver)tile).canConnectEnergy(facing)) {
            return true;
        }
        if (tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(facing)) {
            return true;
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)).canReceive();
        }
        return false;
    }

    public static int insertFlux(TileEntity tile, EnumFacing facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        if (tile instanceof IFluxReceiver && ((IFluxReceiver)tile).canConnectEnergy(facing)) {
            return ((IFluxReceiver)tile).receiveEnergy(facing, energy, simulate);
        }
        if (tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(facing)) {
            return ((IEnergyReceiver)tile).receiveEnergy(facing, energy, simulate);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)).receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static class IEForgeEnergyWrapper
    implements IEnergyStorage {
        final IIEInternalFluxConnector fluxHandler;
        public final EnumFacing side;

        public IEForgeEnergyWrapper(IIEInternalFluxConnector fluxHandler, EnumFacing side) {
            this.fluxHandler = fluxHandler;
            this.side = side;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).receiveEnergy(this.side, maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).extractEnergy(this.side, maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getEnergyStored(this.side);
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getMaxEnergyStored(this.side);
            }
            return 0;
        }

        public boolean canExtract() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitExtract() > 0;
            }
            return false;
        }

        public boolean canReceive() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitReceive() > 0;
            }
            return false;
        }

        public static IEForgeEnergyWrapper[] getDefaultWrapperArray(IIEInternalFluxConnector handler) {
            return new IEForgeEnergyWrapper[]{new IEForgeEnergyWrapper(handler, EnumFacing.DOWN), new IEForgeEnergyWrapper(handler, EnumFacing.UP), new IEForgeEnergyWrapper(handler, EnumFacing.NORTH), new IEForgeEnergyWrapper(handler, EnumFacing.SOUTH), new IEForgeEnergyWrapper(handler, EnumFacing.WEST), new IEForgeEnergyWrapper(handler, EnumFacing.EAST)};
        }
    }

    public static interface IIEInternalFluxConnector
    extends IFluxConnection,
    IEnergyConnection {
        @Nonnull
        public IEEnums.SideConfig getEnergySideConfig(@Nullable EnumFacing var1);

        @Override
        default public boolean canConnectEnergy(@Nullable EnumFacing fd) {
            return this.getEnergySideConfig(fd) != IEEnums.SideConfig.NONE;
        }

        public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing var1);
    }

    public static interface IIEInternalFluxHandler
    extends IIEInternalFluxConnector,
    IFluxReceiver,
    IEnergyReceiver,
    IFluxProvider,
    IEnergyProvider {
        @Nonnull
        public FluxStorage getFluxStorage();

        default public void postEnergyTransferUpdate(int energy, boolean simulate) {
        }

        @Override
        default public int extractEnergy(@Nullable EnumFacing fd, int amount, boolean simulate) {
            if (((TileEntity)this).func_145831_w().field_72995_K || this.getEnergySideConfig(fd) != IEEnums.SideConfig.OUTPUT) {
                return 0;
            }
            int r = this.getFluxStorage().extractEnergy(amount, simulate);
            this.postEnergyTransferUpdate(-r, simulate);
            return r;
        }

        @Override
        default public int getEnergyStored(@Nullable EnumFacing fd) {
            return this.getFluxStorage().getEnergyStored();
        }

        @Override
        default public int getMaxEnergyStored(@Nullable EnumFacing fd) {
            return this.getFluxStorage().getMaxEnergyStored();
        }

        @Override
        default public int receiveEnergy(@Nullable EnumFacing fd, int amount, boolean simulate) {
            if (((TileEntity)this).func_145831_w().field_72995_K || this.getEnergySideConfig(fd) != IEEnums.SideConfig.INPUT) {
                return 0;
            }
            int r = this.getFluxStorage().receiveEnergy(amount, simulate);
            this.postEnergyTransferUpdate(r, simulate);
            return r;
        }
    }
}

