/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMetalPress;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalPress
extends TileEntityMultiblockMetal<TileEntityMetalPress, MetalPressRecipe>
implements IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorAttachable {
    public ItemStack mold = null;
    IItemHandler insertionHandler = new TileEntityMultiblockMetal.MultiblockInventoryHandler_DirectProcessing(this);

    public TileEntityMetalPress() {
        super(MultiblockMetalPress.instance, new int[]{3, 3, 1}, 16000, true);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K) {
            return;
        }
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
            float tick = 1.0f / (float)process.maxTicks;
            float transportTime = 52.5f * tick;
            float pressTime = 3.75f * tick;
            float fProcess = (float)process.processTick * tick;
            if (fProcess >= transportTime && fProcess < transportTime + tick) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f, true);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + tick) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, IESounds.metalpress_smash, SoundCategory.BLOCKS, 0.3f, 1.0f, true);
            }
            if (!(fProcess >= 1.0f - transportTime) || !(fProcess < 1.0f - transportTime + tick)) continue;
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, IESounds.metalpress_piston, SoundCategory.BLOCKS, 0.3f, 1.0f, true);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.mold = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("mold"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.mold != null) {
            nbt.func_74782_a("mold", (NBTBase)this.mold.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntityMetalPress master = (TileEntityMetalPress)this.master();
        if (master != null) {
            if (player.func_70093_af() && master.mold != null) {
                if (heldItem == null) {
                    player.func_184611_a(hand, master.mold.func_77946_l());
                } else if (!this.field_145850_b.field_72995_K) {
                    player.func_70099_a(master.mold.func_77946_l(), 0.0f);
                }
                master.mold = null;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (MetalPressRecipe.isValidMold(heldItem)) {
                ItemStack tempMold = master.mold != null ? master.mold.func_77946_l() : null;
                master.mold = Utils.copyStackWithAmount(heldItem, 1);
                if (heldItem.field_77994_a-- <= 0) {
                    heldItem = null;
                } else {
                    player.func_184611_a(hand, heldItem);
                }
                if (tempMold != null) {
                    if (heldItem == null) {
                        player.func_184611_a(hand, tempMold);
                    } else if (!this.field_145850_b.field_72995_K) {
                        player.func_70099_a(tempMold, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 3 || this.field_174879_c == 5) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && l != 1 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.facing);
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.field_174879_c == 3 && !world.field_72995_K && entity != null && !entity.field_70128_L && entity instanceof EntityItem && ((EntityItem)entity).func_92059_d() != null) {
            float transformationPoint;
            TileEntityMultiblockMetal.MultiblockProcessInWorld<MetalPressRecipe> process;
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            if (stack == null) {
                return;
            }
            MetalPressRecipe recipe = master.findRecipeForInsertion(stack);
            if (recipe == null) {
                return;
            }
            ItemStack displayStack = null;
            for (IngredientStack ingr : recipe.getItemInputs()) {
                if (!ingr.matchesItemStack(stack)) continue;
                displayStack = Utils.copyStackWithAmount(stack, ingr.inputSize);
                break;
            }
            if (master.addProcessToQueue(process = new TileEntityMultiblockMetal.MultiblockProcessInWorld<MetalPressRecipe>(recipe, transformationPoint = 56.25f / (float)recipe.getTotalProcessTime(), displayStack), true)) {
                master.addProcessToQueue(process, false);
                stack.field_77994_a -= displayStack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    entity.func_70106_y();
                }
            }
        }
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{7};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<MetalPressRecipe> process) {
        return ((float)((MetalPressRecipe)process.recipe).getTotalProcessTime() - 56.25f) / (float)((MetalPressRecipe)process.recipe).getTotalProcessTime();
    }

    @Override
    public ItemStack[] getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return false;
            }
            return this.field_174879_c == 3 && facing == this.facing.func_176734_d();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityMetalPress master = (TileEntityMetalPress)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 3 && facing == this.facing.func_176734_d()) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MetalPressRecipe findRecipeForInsertion(ItemStack inserting) {
        return MetalPressRecipe.findRecipe(this.mold, inserting, true);
    }

    @Override
    protected MetalPressRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return MetalPressRecipe.loadFromNBT(tag);
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 5) {
            return new EnumFacing[]{this.facing};
        }
        return new EnumFacing[0];
    }
}

