/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.liquidEgg;

import com.setycz.chickens.IColorSource;
import com.setycz.chickens.LiquidEggRegistry;
import com.setycz.chickens.LiquidEggRegistryItem;
import com.setycz.chickens.liquidEgg.LiquidEggFluidWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLiquidEgg
extends ItemEgg
implements IColorSource {
    public ItemLiquidEgg() {
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(I18n.func_74838_a((String)"item.liquid_egg.tooltip"));
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (LiquidEggRegistryItem liquid : LiquidEggRegistry.getAll()) {
            subItems.add(new ItemStack(itemIn, 1, liquid.getId()));
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return LiquidEggRegistry.findById(stack.func_77960_j()).getEggColor();
    }

    public String func_77653_i(ItemStack stack) {
        Block liquid = LiquidEggRegistry.findById(stack.func_77960_j()).getLiquid();
        return I18n.func_74838_a((String)(this.func_77658_a() + "." + liquid.func_149739_a().substring(5) + ".name"));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, false);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!worldIn.func_175660_a(playerIn, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        boolean flag1 = worldIn.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos);
        BlockPos blockPos1 = flag1 && raytraceresult.field_178784_b == EnumFacing.UP ? blockpos : blockpos.func_177972_a(raytraceresult.field_178784_b);
        Block liquid = LiquidEggRegistry.findById(itemStackIn.func_77960_j()).getLiquid();
        if (!playerIn.func_175151_a(blockPos1, raytraceresult.field_178784_b, itemStackIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockPos1, liquid)) {
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            return !playerIn.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(itemStackIn.func_77973_b(), itemStackIn.field_77994_a - 1, itemStackIn.func_77960_j())) : new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public boolean tryPlaceContainedLiquid(@Nullable EntityPlayer playerIn, World worldIn, BlockPos pos, Block liquid) {
        boolean flag;
        Material material = worldIn.func_180495_p(pos).func_185904_a();
        boolean bl = flag = !material.func_76220_a();
        if (!worldIn.func_175623_d(pos) && !flag) {
            return false;
        }
        if (worldIn.field_73011_w.func_177500_n() && liquid == Blocks.field_150358_i) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                worldIn.func_175655_b(pos, true);
            }
            worldIn.func_180501_a(pos, liquid.func_176223_P(), 3);
        }
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new LiquidEggFluidWrapper(stack);
    }
}

