/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.jei;

import com.setycz.chickens.ChickensMod;
import com.setycz.chickens.ChickensRegistry;
import com.setycz.chickens.ChickensRegistryItem;
import com.setycz.chickens.jei.breeding.BreedingRecipeCategory;
import com.setycz.chickens.jei.breeding.BreedingRecipeHandler;
import com.setycz.chickens.jei.breeding.BreedingRecipeWrapper;
import com.setycz.chickens.jei.drop.DropRecipeCategory;
import com.setycz.chickens.jei.drop.DropRecipeHandler;
import com.setycz.chickens.jei.drop.DropRecipeWrapper;
import com.setycz.chickens.jei.henhousing.HenhousingRecipeCategory;
import com.setycz.chickens.jei.henhousing.HenhousingRecipeHandler;
import com.setycz.chickens.jei.henhousing.HenhousingRecipeWrapper;
import com.setycz.chickens.jei.laying.LayingRecipeCategory;
import com.setycz.chickens.jei.laying.LayingRecipeHandler;
import com.setycz.chickens.jei.laying.LayingRecipeWrapper;
import com.setycz.chickens.jei.throwing.ThrowingRecipeCategory;
import com.setycz.chickens.jei.throwing.ThrowingRecipeHandler;
import com.setycz.chickens.jei.throwing.ThrowingRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class ChickensJeiPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new LayingRecipeCategory(jeiHelpers.getGuiHelper()), new BreedingRecipeCategory(jeiHelpers.getGuiHelper()), new DropRecipeCategory(jeiHelpers.getGuiHelper()), new ThrowingRecipeCategory(jeiHelpers.getGuiHelper()), new HenhousingRecipeCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new LayingRecipeHandler(), new BreedingRecipeHandler(), new DropRecipeHandler(), new ThrowingRecipeHandler(), new HenhousingRecipeHandler()});
        registry.addRecipes(this.getLayingRecipes());
        registry.addRecipes(this.getBreedingRecipes());
        registry.addRecipes(this.getDropRecipes());
        registry.addRecipes(this.getThrowRecipes());
        registry.addRecipes(this.getHenhouseRecipes());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    private List<LayingRecipeWrapper> getLayingRecipes() {
        ArrayList<LayingRecipeWrapper> result = new ArrayList<LayingRecipeWrapper>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            result.add(new LayingRecipeWrapper(new ItemStack(ChickensMod.spawnEgg, 1, chicken.getId()), chicken.createLayItem(), chicken.getMinLayTime(), chicken.getMaxLayTime()));
        }
        return result;
    }

    private List<DropRecipeWrapper> getDropRecipes() {
        ArrayList<DropRecipeWrapper> result = new ArrayList<DropRecipeWrapper>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            result.add(new DropRecipeWrapper(new ItemStack(ChickensMod.spawnEgg, 1, chicken.getId()), chicken.createDropItem()));
        }
        return result;
    }

    private List<BreedingRecipeWrapper> getBreedingRecipes() {
        ArrayList<BreedingRecipeWrapper> result = new ArrayList<BreedingRecipeWrapper>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (!chicken.isBreedable()) continue;
            result.add(new BreedingRecipeWrapper(new ItemStack(ChickensMod.spawnEgg, 1, chicken.getParent1().getId()), new ItemStack(ChickensMod.spawnEgg, 1, chicken.getParent2().getId()), new ItemStack(ChickensMod.spawnEgg, 1, chicken.getId()), ChickensRegistry.getChildChance(chicken)));
        }
        return result;
    }

    private List<ThrowingRecipeWrapper> getThrowRecipes() {
        ArrayList<ThrowingRecipeWrapper> result = new ArrayList<ThrowingRecipeWrapper>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (!chicken.isDye()) continue;
            result.add(new ThrowingRecipeWrapper(new ItemStack(ChickensMod.coloredEgg, 1, chicken.getDyeMetadata()), new ItemStack(ChickensMod.spawnEgg, 1, chicken.getId())));
        }
        return result;
    }

    private List<HenhousingRecipeWrapper> getHenhouseRecipes() {
        ArrayList<HenhousingRecipeWrapper> henhouseRecipes = new ArrayList<HenhousingRecipeWrapper>();
        henhouseRecipes.add(new HenhousingRecipeWrapper(new ItemStack(Blocks.field_150407_cf), new ItemStack(Blocks.field_150346_d)));
        return henhouseRecipes;
    }
}

