/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens;

import com.setycz.chickens.SpawnType;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ChickensRegistryItem {
    private final int id;
    private final String entityName;
    private ItemStack layItem;
    private ItemStack dropItem;
    private final int bgColor;
    private final int fgColor;
    private final ResourceLocation texture;
    private ChickensRegistryItem parent1;
    private ChickensRegistryItem parent2;
    private SpawnType spawnType;
    private boolean isEnabled = true;
    private float layCoefficient = 1.0f;

    public ChickensRegistryItem(int id, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor, int fgColor) {
        this(id, entityName, texture, layItem, bgColor, fgColor, null, null);
    }

    public ChickensRegistryItem(int id, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor, int fgColor, @Nullable ChickensRegistryItem parent1, @Nullable ChickensRegistryItem parent2) {
        this.id = id;
        this.entityName = entityName;
        this.layItem = layItem;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.texture = texture;
        this.spawnType = SpawnType.NORMAL;
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    public ChickensRegistryItem setDropItem(ItemStack stack) {
        this.dropItem = stack;
        return this;
    }

    public ChickensRegistryItem setSpawnType(SpawnType type) {
        this.spawnType = type;
        return this;
    }

    public ChickensRegistryItem setLayCoefficient(float coef) {
        this.layCoefficient = coef;
        return this;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Nullable
    public ChickensRegistryItem getParent1() {
        return this.parent1;
    }

    @Nullable
    public ChickensRegistryItem getParent2() {
        return this.parent2;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ItemStack createLayItem() {
        return this.layItem.func_77946_l();
    }

    public ItemStack createDropItem() {
        if (this.dropItem != null) {
            return this.dropItem.func_77946_l();
        }
        return this.createLayItem();
    }

    public int getTier() {
        if (this.parent1 == null || this.parent2 == null) {
            return 1;
        }
        return Math.max(this.parent1.getTier(), this.parent2.getTier()) + 1;
    }

    public boolean isChildOf(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        return this.parent1 == parent1 && this.parent2 == parent2 || this.parent1 == parent2 && this.parent2 == parent1;
    }

    public boolean isDye() {
        return this.layItem.func_77973_b() == Items.field_151100_aR;
    }

    public boolean isDye(int dyeMetadata) {
        return this.layItem.func_77973_b() == Items.field_151100_aR && this.layItem.func_77960_j() == dyeMetadata;
    }

    public int getDyeMetadata() {
        return this.layItem.func_77960_j();
    }

    public boolean canSpawn() {
        return this.getTier() == 1 && this.spawnType != SpawnType.NONE;
    }

    public int getId() {
        return this.id;
    }

    public int getMinLayTime() {
        return (int)Math.max((float)(6000 * this.getTier()) * this.layCoefficient, 1.0f);
    }

    public int getMaxLayTime() {
        return 2 * this.getMinLayTime();
    }

    public SpawnType getSpawnType() {
        return this.spawnType;
    }

    public boolean isImmuneToFire() {
        return this.spawnType == SpawnType.HELL;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return !(!this.isEnabled || this.parent1 != null && !this.parent1.isEnabled() || this.parent2 != null && !this.parent2.isEnabled());
    }

    public void setLayItem(ItemStack itemStack) {
        this.layItem = itemStack;
    }

    public void setNoParents() {
        this.parent1 = null;
        this.parent2 = null;
    }

    public ChickensRegistryItem setParentsNew(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        return this;
    }

    @Deprecated
    public void setParents(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    public boolean isBreedable() {
        return this.parent1 != null && this.parent2 != null;
    }
}

