/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens;

import com.setycz.chickens.ChickenTeachHandler;
import com.setycz.chickens.ChickensRegistry;
import com.setycz.chickens.ChickensRegistryItem;
import com.setycz.chickens.ChickensTab;
import com.setycz.chickens.CommonProxy;
import com.setycz.chickens.LiquidEggRegistry;
import com.setycz.chickens.LiquidEggRegistryItem;
import com.setycz.chickens.SpawnType;
import com.setycz.chickens.TileEntityGuiHandler;
import com.setycz.chickens.analyzer.ItemAnalyzer;
import com.setycz.chickens.chicken.ChickenNetherPopulateHandler;
import com.setycz.chickens.chicken.EntityChickensChicken;
import com.setycz.chickens.coloredEgg.ItemColoredEgg;
import com.setycz.chickens.henhouse.BlockHenhouse;
import com.setycz.chickens.henhouse.TileEntityHenhouse;
import com.setycz.chickens.liquidEgg.ItemLiquidEgg;
import com.setycz.chickens.spawnEgg.ItemSpawnEgg;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="chickens", version="4.3.2", acceptedMinecraftVersions="[1.10.2]", dependencies="required-after:Forge@[12.18.3.2185,);")
public class ChickensMod {
    public static final String MODID = "chickens";
    public static final String VERSION = "4.3.2";
    public static final String CHICKEN = "ChickensChicken";
    private static final Logger log = LogManager.getLogger((String)"chickens");
    @Mod.Instance(value="chickens")
    public static ChickensMod instance;
    private static final CreativeTabs tab;
    private int chickenEntityId = 30000;
    private int spawnProbability = 10;
    private int minBroodSize = 3;
    private int maxBroodSize = 5;
    private float netherSpawnChanceMultiplier = 1.0f;
    private boolean alwaysShowStats = false;
    public static final Item spawnEgg;
    public static final Item coloredEgg;
    public static final Item liquidEgg;
    public static final Item analyzer;
    public static final Block henhouse;
    public static final Block henhouse_acacia;
    public static final Block henhouse_birch;
    public static final Block henhouse_dark_oak;
    public static final Block henhouse_jungle;
    public static final Block henhouse_spruce;
    public static final TileEntityGuiHandler guiHandler;
    @SidedProxy(clientSide="com.setycz.chickens.ClientProxy", serverSide="com.setycz.chickens.CommonProxy")
    public static CommonProxy proxy;

    public boolean getAlwaysShowStats() {
        return this.alwaysShowStats;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        EntityRegistry.registerModEntity(EntityChickensChicken.class, (String)CHICKEN, (int)this.chickenEntityId, (Object)this, (int)64, (int)3, (boolean)true);
        GameRegistry.register((IForgeRegistryEntry)coloredEgg);
        GameRegistry.register((IForgeRegistryEntry)spawnEgg);
        GameRegistry.register((IForgeRegistryEntry)liquidEgg);
        GameRegistry.register((IForgeRegistryEntry)analyzer);
        GameRegistry.registerTileEntity(TileEntityHenhouse.class, (String)"henhouse");
        this.registerBlock(henhouse);
        this.registerBlock(henhouse_acacia);
        this.registerBlock(henhouse_birch);
        this.registerBlock(henhouse_dark_oak);
        this.registerBlock(henhouse_jungle);
        this.registerBlock(henhouse_spruce);
        this.registerLiquidEggs();
        this.loadConfiguration(event.getSuggestedConfigurationFile());
        log.info("Enabled chickens: {}", new Object[]{this.getChickenNames(ChickensRegistry.getItems())});
        log.info("Disabled chickens: {}", new Object[]{this.getChickenNames(ChickensRegistry.getDisabledItems())});
        for (SpawnType spawnType : SpawnType.values()) {
            log.info("[{}] biome type will spawn {} ({})", new Object[]{spawnType, this.getChickenNames(ChickensRegistry.getPossibleChickensToSpawn(spawnType))});
        }
        this.dumpChickens(ChickensRegistry.getItems());
    }

    private void registerBlock(Block block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    private List<String> getChickenNames(Collection<ChickensRegistryItem> chickens) {
        ArrayList<String> result = new ArrayList<String>();
        for (ChickensRegistryItem chicken : chickens) {
            result.add(chicken.getEntityName());
        }
        return result;
    }

    private void loadConfiguration(File configFile) {
        Configuration configuration = new Configuration(configFile);
        this.chickenEntityId = configuration.getInt("entityId", "general", 30000, Integer.MIN_VALUE, Integer.MAX_VALUE, "Chicken Entity ID");
        this.spawnProbability = configuration.getInt("spawnProbability", "general", 10, Integer.MIN_VALUE, Integer.MAX_VALUE, "Spawn probability");
        this.minBroodSize = configuration.getInt("minBroodSize", "general", 3, 1, Integer.MAX_VALUE, "Minimal brood size");
        this.maxBroodSize = configuration.getInt("maxBroodSize", "general", 5, 2, Integer.MAX_VALUE, "Maximal brood size, must be greater than the minimal size");
        this.netherSpawnChanceMultiplier = configuration.getFloat("netherSpawnChanceMultiplier", "general", 1.0f, 0.0f, Float.MAX_VALUE, "Nether chicken spawn chance multiplier, e.g. 0=no initial spawn, 2=two times more spawn rate");
        this.alwaysShowStats = configuration.getBoolean("alwaysShowStats", "general", false, "Stats will be always shown in WAILA without the need to analyze chickens first when enabled.");
        List<ChickensRegistryItem> allChickens = this.generateDefaultChickens();
        for (ChickensRegistryItem chicken : allChickens) {
            boolean enabled = configuration.getBoolean("enabled", chicken.getEntityName(), true, "Is chicken enabled?");
            chicken.setEnabled(enabled);
            float layCoefficient = configuration.getFloat("layCoefficient", chicken.getEntityName(), 1.0f, 0.01f, 100.0f, "Scale time to lay an egg.");
            chicken.setLayCoefficient(layCoefficient);
            ItemStack itemStack = this.loadItemStack(configuration, chicken, "egg", chicken.createLayItem());
            chicken.setLayItem(itemStack);
            ItemStack dropItemStack = this.loadItemStack(configuration, chicken, "drop", chicken.createDropItem());
            chicken.setDropItem(dropItemStack);
            ChickensRegistryItem parent1 = this.getChickenParent(configuration, "parent1", allChickens, chicken, chicken.getParent1());
            ChickensRegistryItem parent2 = this.getChickenParent(configuration, "parent2", allChickens, chicken, chicken.getParent2());
            if (parent1 != null && parent2 != null) {
                chicken.setParentsNew(parent1, parent2);
            } else {
                chicken.setNoParents();
            }
            String spawnTypes = this.getAllAvailableSpawnTypes();
            SpawnType spawnType = SpawnType.valueOf(configuration.getString("spawnType", chicken.getEntityName(), chicken.getSpawnType().toString(), "Chicken spawn type, can be: " + spawnTypes));
            chicken.setSpawnType(spawnType);
            ChickensRegistry.register(chicken);
        }
        configuration.save();
    }

    private String getAllAvailableSpawnTypes() {
        String spawnTypes = "";
        String[] spawnTypeNames = SpawnType.names();
        for (int spawnTypeIndex = 0; spawnTypeIndex < spawnTypeNames.length; ++spawnTypeIndex) {
            if (spawnTypeIndex > 0) {
                spawnTypes = spawnTypes + ", ";
            }
            spawnTypes = spawnTypes + spawnTypeNames[spawnTypeIndex];
        }
        return spawnTypes;
    }

    @Nullable
    private ChickensRegistryItem getChickenParent(Configuration configuration, String propertyName, Collection<ChickensRegistryItem> allChickens, ChickensRegistryItem chicken, @Nullable ChickensRegistryItem parent) {
        String parentName = configuration.getString(propertyName, chicken.getEntityName(), parent != null ? parent.getEntityName() : "", "First parent, empty if it's base chicken.");
        return this.findChicken(allChickens, parentName);
    }

    @Nullable
    private ChickensRegistryItem findChicken(Collection<ChickensRegistryItem> chickens, String name) {
        for (ChickensRegistryItem chicken : chickens) {
            if (chicken.getEntityName().compareToIgnoreCase(name) != 0) continue;
            return chicken;
        }
        return null;
    }

    private ItemStack loadItemStack(Configuration configuration, ChickensRegistryItem chicken, String prefix, ItemStack defaultItemStack) {
        String itemName = configuration.getString(prefix + "ItemName", chicken.getEntityName(), defaultItemStack.func_77973_b().getRegistryName().toString(), "Item name to be laid/dropped.");
        int itemAmount = configuration.getInt(prefix + "ItemAmount", chicken.getEntityName(), defaultItemStack.field_77994_a, 1, 64, "Item amount to be laid/dropped.");
        int itemMeta = configuration.getInt(prefix + "ItemMeta", chicken.getEntityName(), defaultItemStack.func_77960_j(), Integer.MIN_VALUE, Integer.MAX_VALUE, "Item amount to be laid/dropped.");
        ResourceLocation itemResourceLocation = new ResourceLocation(itemName);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)itemResourceLocation);
        if (item == null) {
            throw new RuntimeException("Cannot find egg item with name: " + itemName);
        }
        return new ItemStack(item, itemAmount, itemMeta);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChickenTeachHandler());
        List<Biome> biomesForSpawning = this.getAllSpawnBiomes();
        if (biomesForSpawning.size() > 0) {
            EntityRegistry.addSpawn(EntityChickensChicken.class, (int)this.spawnProbability, (int)this.minBroodSize, (int)this.maxBroodSize, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomesForSpawning.toArray(new Biome[biomesForSpawning.size()]));
            if (biomesForSpawning.contains(Biomes.field_76778_j)) {
                MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ChickenNetherPopulateHandler(this.netherSpawnChanceMultiplier));
            }
        }
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            proxy.registerChicken(chicken);
        }
        for (LiquidEggRegistryItem liquidEgg : LiquidEggRegistry.getAll()) {
            proxy.registerLiquidEgg(liquidEgg);
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(analyzer, 1), (Object[])new Object[]{new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151111_aL)});
        this.registerHenhouse(henhouse_acacia, BlockPlanks.EnumType.ACACIA);
        this.registerHenhouse(henhouse_birch, BlockPlanks.EnumType.BIRCH);
        this.registerHenhouse(henhouse_dark_oak, BlockPlanks.EnumType.DARK_OAK);
        this.registerHenhouse(henhouse_jungle, BlockPlanks.EnumType.JUNGLE);
        this.registerHenhouse(henhouse_spruce, BlockPlanks.EnumType.SPRUCE);
        this.registerHenhouse(henhouse, BlockPlanks.EnumType.OAK);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.setycz.chickens.waila.ChickensEntityProvider.load");
    }

    private boolean requiresVisitingNether(ChickensRegistryItem chicken) {
        return chicken.getTier() == 1 ? chicken.getSpawnType() == SpawnType.HELL : this.requiresVisitingNether(chicken.getParent1()) || this.requiresVisitingNether(chicken.getParent2());
    }

    private void dumpChickens(Collection<ChickensRegistryItem> items) {
        try {
            FileWriter file = new FileWriter("logs/chickens.gml");
            file.write("graph [\n");
            file.write("\tdirected 1\n");
            for (ChickensRegistryItem item : items) {
                file.write("\tnode [\n");
                file.write("\t\tid " + item.getId() + "\n");
                file.write("\t\tlabel \"" + item.getEntityName() + "\"\n");
                if (this.requiresVisitingNether(item)) {
                    file.write("\t\tgraphics [\n");
                    file.write("\t\t\tfill \"#FF6600\"\n");
                    file.write("\t\t]\n");
                }
                file.write("\t]\n");
            }
            for (ChickensRegistryItem item : items) {
                if (item.getParent1() != null) {
                    file.write("\tedge [\n");
                    file.write("\t\tsource " + item.getParent1().getId() + "\n");
                    file.write("\t\ttarget " + item.getId() + "\n");
                    file.write("\t]\n");
                }
                if (item.getParent2() == null) continue;
                file.write("\tedge [\n");
                file.write("\t\tsource " + item.getParent2().getId() + "\n");
                file.write("\t\ttarget " + item.getId() + "\n");
                file.write("\t]\n");
            }
            file.write("]\n");
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void registerHenhouse(Block henhouse, BlockPlanks.EnumType type) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)henhouse)), new Object[]{"PPP", "PHP", "PPP", Character.valueOf('P'), type == BlockPlanks.EnumType.OAK ? "plankWood" : new ItemStack(Blocks.field_150344_f, 1, type.func_176839_a()), Character.valueOf('H'), Blocks.field_150407_cf}));
    }

    private List<Biome> getAllSpawnBiomes() {
        Biome[] allPossibleBiomes = new Biome[]{Biomes.field_76772_c, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76774_n, Biomes.field_76775_o, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_76783_v, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76770_e, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_76778_j};
        ArrayList<Biome> biomesForSpawning = new ArrayList<Biome>();
        for (Biome biome : allPossibleBiomes) {
            if (!ChickensRegistry.isAnyIn(ChickensRegistry.getSpawnType(biome))) continue;
            biomesForSpawning.add(biome);
        }
        return biomesForSpawning;
    }

    private void registerLiquidEggs() {
        LiquidEggRegistry.register(new LiquidEggRegistryItem(0, (Block)Blocks.field_150358_i, 255, FluidRegistry.WATER));
        LiquidEggRegistry.register(new LiquidEggRegistryItem(1, (Block)Blocks.field_150356_k, 0xFF0000, FluidRegistry.LAVA));
    }

    ChickensRegistryItem createDyeChicken(EnumDyeColor color, String name) {
        return new ChickensRegistryItem(color.func_176765_a(), name, new ResourceLocation(MODID, "textures/entity/" + name + ".png"), new ItemStack(Items.field_151100_aR, 1, color.func_176767_b()), 0xF2F2F2, color.func_176768_e().field_76291_p).setSpawnType(SpawnType.NONE);
    }

    private List<ChickensRegistryItem> generateDefaultChickens() {
        ArrayList<ChickensRegistryItem> chickens = new ArrayList<ChickensRegistryItem>();
        chickens.add(new ChickensRegistryItem(50, "SmartChicken", new ResourceLocation(MODID, "textures/entity/SmartChicken.png"), new ItemStack(Items.field_151110_aK), 0xFFFFFF, 0xFFFF00).setSpawnType(SpawnType.NONE));
        ChickensRegistryItem whiteChicken = this.createDyeChicken(EnumDyeColor.WHITE, "WhiteChicken").setDropItem(new ItemStack(Items.field_151103_aS)).setSpawnType(SpawnType.NORMAL);
        chickens.add(whiteChicken);
        ChickensRegistryItem yellowChicken = this.createDyeChicken(EnumDyeColor.YELLOW, "YellowChicken");
        chickens.add(yellowChicken);
        ChickensRegistryItem blueChicken = this.createDyeChicken(EnumDyeColor.BLUE, "BlueChicken");
        chickens.add(blueChicken);
        ChickensRegistryItem greenChicken = this.createDyeChicken(EnumDyeColor.GREEN, "GreenChicken");
        chickens.add(greenChicken);
        ChickensRegistryItem redChicken = this.createDyeChicken(EnumDyeColor.RED, "RedChicken");
        chickens.add(redChicken);
        ChickensRegistryItem blackChicken = this.createDyeChicken(EnumDyeColor.BLACK, "BlackChicken");
        chickens.add(blackChicken);
        ChickensRegistryItem pinkChicken = this.createDyeChicken(EnumDyeColor.PINK, "PinkChicken").setParentsNew(redChicken, whiteChicken);
        chickens.add(pinkChicken);
        ChickensRegistryItem purpleChicken = this.createDyeChicken(EnumDyeColor.PURPLE, "PurpleChicken").setParentsNew(blueChicken, redChicken);
        chickens.add(purpleChicken);
        chickens.add(this.createDyeChicken(EnumDyeColor.ORANGE, "OrangeChicken").setParentsNew(redChicken, yellowChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.LIGHT_BLUE, "LightBlueChicken").setParentsNew(whiteChicken, blueChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.LIME, "LimeChicken").setParentsNew(greenChicken, whiteChicken));
        ChickensRegistryItem grayChicken = this.createDyeChicken(EnumDyeColor.GRAY, "GrayChicken").setParentsNew(blackChicken, whiteChicken);
        chickens.add(grayChicken);
        chickens.add(this.createDyeChicken(EnumDyeColor.CYAN, "CyanChicken").setParentsNew(blueChicken, greenChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.SILVER, "SilverDyeChicken").setParentsNew(grayChicken, whiteChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.MAGENTA, "MagentaChicken").setParentsNew(purpleChicken, pinkChicken));
        ChickensRegistryItem flintChicken = new ChickensRegistryItem(101, "FlintChicken", new ResourceLocation(MODID, "textures/entity/FlintChicken.png"), new ItemStack(Items.field_151145_ak), 7039815, 10724213);
        chickens.add(flintChicken);
        ChickensRegistryItem quartzChicken = new ChickensRegistryItem(104, "QuartzChicken", new ResourceLocation(MODID, "textures/entity/QuartzChicken.png"), new ItemStack(Items.field_151128_bU), 0x4D0000, 0x1A0000).setSpawnType(SpawnType.HELL);
        chickens.add(quartzChicken);
        ChickensRegistryItem logChicken = new ChickensRegistryItem(108, "LogChicken", new ResourceLocation(MODID, "textures/entity/LogChicken.png"), new ItemStack(Blocks.field_150364_r), 9995373, 5407576);
        chickens.add(logChicken);
        ChickensRegistryItem sandChicken = new ChickensRegistryItem(105, "SandChicken", new ResourceLocation(MODID, "textures/entity/SandChicken.png"), new ItemStack((Block)Blocks.field_150354_m), 15525297, 10985580);
        chickens.add(sandChicken);
        ChickensRegistryItem stringChicken = new ChickensRegistryItem(303, "StringChicken", new ResourceLocation(MODID, "textures/entity/StringChicken.png"), new ItemStack(Items.field_151007_F), 3348992, 0x800000, blackChicken, logChicken).setDropItem(new ItemStack(Items.field_151070_bp));
        chickens.add(stringChicken);
        ChickensRegistryItem glowstoneChicken = new ChickensRegistryItem(202, "GlowstoneChicken", new ResourceLocation(MODID, "textures/entity/GlowstoneChicken.png"), new ItemStack(Items.field_151114_aO), 0xFFFF66, 0xFFFF00, quartzChicken, yellowChicken);
        chickens.add(glowstoneChicken);
        ChickensRegistryItem gunpowderChicken = new ChickensRegistryItem(100, "GunpowderChicken", new ResourceLocation(MODID, "textures/entity/GunpowderChicken.png"), new ItemStack(Items.field_151016_H), 0x999999, 0x404040, sandChicken, flintChicken);
        chickens.add(gunpowderChicken);
        ChickensRegistryItem redstoneChicken = new ChickensRegistryItem(201, "RedstoneChicken", new ResourceLocation(MODID, "textures/entity/RedstoneChicken.png"), new ItemStack(Items.field_151137_ax), 0xE60000, 0x800000, redChicken, sandChicken);
        chickens.add(redstoneChicken);
        ChickensRegistryItem glassChicken = new ChickensRegistryItem(106, "GlassChicken", new ResourceLocation(MODID, "textures/entity/GlassChicken.png"), new ItemStack(Blocks.field_150359_w), 0xFFFFFF, 0xEEEEFF, quartzChicken, redstoneChicken);
        chickens.add(glassChicken);
        ChickensRegistryItem ironChicken = new ChickensRegistryItem(203, "IronChicken", new ResourceLocation(MODID, "textures/entity/IronChicken.png"), new ItemStack(Items.field_151042_j), 0xFFFFCC, 0xFFCCCC, flintChicken, whiteChicken);
        chickens.add(ironChicken);
        ChickensRegistryItem coalChicken = new ChickensRegistryItem(204, "CoalChicken", new ResourceLocation(MODID, "textures/entity/CoalChicken.png"), new ItemStack(Items.field_151044_h), 0x262626, 0, flintChicken, logChicken);
        chickens.add(coalChicken);
        ChickensRegistryItem brownChicken = this.createDyeChicken(EnumDyeColor.BROWN, "BrownChicken").setParentsNew(redChicken, greenChicken);
        chickens.add(brownChicken);
        ChickensRegistryItem goldChicken = new ChickensRegistryItem(300, "GoldChicken", new ResourceLocation(MODID, "textures/entity/GoldChicken.png"), new ItemStack(Items.field_151074_bl), 0xCCCC00, 0xFFFF80, ironChicken, yellowChicken);
        chickens.add(goldChicken);
        ChickensRegistryItem snowballChicken = new ChickensRegistryItem(102, "SnowballChicken", new ResourceLocation(MODID, "textures/entity/SnowballChicken.png"), new ItemStack(Items.field_151126_ay), 0x33BBFF, 35020, blueChicken, logChicken).setSpawnType(SpawnType.SNOW);
        chickens.add(snowballChicken);
        ChickensRegistryItem waterChicken = new ChickensRegistryItem(206, "WaterChicken", new ResourceLocation(MODID, "textures/entity/WaterChicken.png"), new ItemStack(liquidEgg, 1, 0), 153, 0x8080FF, gunpowderChicken, snowballChicken);
        chickens.add(waterChicken);
        ChickensRegistryItem lavaChicken = new ChickensRegistryItem(103, "LavaChicken", new ResourceLocation(MODID, "textures/entity/LavaChicken.png"), new ItemStack(liquidEgg, 1, 1), 0xCC3300, 0xFFFF00, coalChicken, quartzChicken).setSpawnType(SpawnType.HELL);
        chickens.add(lavaChicken);
        ChickensRegistryItem clayChicken = new ChickensRegistryItem(200, "ClayChicken", new ResourceLocation(MODID, "textures/entity/ClayChicken.png"), new ItemStack(Items.field_151119_aD), 0xCCCCCC, 0xBFBFBF, snowballChicken, sandChicken);
        chickens.add(clayChicken);
        ChickensRegistryItem leatherChicken = new ChickensRegistryItem(107, "LeatherChicken", new ResourceLocation(MODID, "textures/entity/LeatherChicken.png"), new ItemStack(Items.field_151116_aA), 10985580, 0x919191, stringChicken, brownChicken);
        chickens.add(leatherChicken);
        ChickensRegistryItem netherwartChicken = new ChickensRegistryItem(207, "NetherwartChicken", new ResourceLocation(MODID, "textures/entity/NetherwartChicken.png"), new ItemStack(Items.field_151075_bm), 0x800000, 3348992, brownChicken, glowstoneChicken);
        chickens.add(netherwartChicken);
        ChickensRegistryItem diamondChicken = new ChickensRegistryItem(301, "DiamondChicken", new ResourceLocation(MODID, "textures/entity/DiamondChicken.png"), new ItemStack(Items.field_151045_i), 0x99CCFF, 15135487, glassChicken, goldChicken);
        chickens.add(diamondChicken);
        ChickensRegistryItem blazeChicken = new ChickensRegistryItem(302, "BlazeChicken", new ResourceLocation(MODID, "textures/entity/BlazeChicken.png"), new ItemStack(Items.field_151072_bj), 0xFFFF66, 0xFF3300, goldChicken, lavaChicken);
        chickens.add(blazeChicken);
        ChickensRegistryItem slimeChicken = new ChickensRegistryItem(205, "SlimeChicken", new ResourceLocation(MODID, "textures/entity/SlimeChicken.png"), new ItemStack(Items.field_151123_aH), 39219, 0x99FFBB, clayChicken, greenChicken);
        chickens.add(slimeChicken);
        ChickensRegistryItem enderChicken = new ChickensRegistryItem(401, "EnderChicken", new ResourceLocation(MODID, "textures/entity/EnderChicken.png"), new ItemStack(Items.field_151079_bi), 6656, 6707, diamondChicken, netherwartChicken);
        chickens.add(enderChicken);
        ChickensRegistryItem ghastChicken = new ChickensRegistryItem(402, "GhastChicken", new ResourceLocation(MODID, "textures/entity/GhastChicken.png"), new ItemStack(Items.field_151073_bk), 0xFFFFCC, 0xFFFFFF, whiteChicken, blazeChicken);
        chickens.add(ghastChicken);
        ChickensRegistryItem emeraldChicken = new ChickensRegistryItem(400, "EmeraldChicken", new ResourceLocation(MODID, "textures/entity/EmeraldChicken.png"), new ItemStack(Items.field_151166_bC), 52224, 13056, diamondChicken, greenChicken);
        chickens.add(emeraldChicken);
        ChickensRegistryItem magmaChicken = new ChickensRegistryItem(403, "MagmaChicken", new ResourceLocation(MODID, "textures/entity/MagmaChicken.png"), new ItemStack(Items.field_151064_bs), 1705216, 0, slimeChicken, blazeChicken);
        chickens.add(magmaChicken);
        return chickens;
    }

    public static String getItemName(Item item) {
        return item.func_77658_a().substring(5);
    }

    public static String getBlockName(Block block) {
        return block.func_149739_a().substring(5);
    }

    static {
        tab = new ChickensTab();
        spawnEgg = ((Item)new ItemSpawnEgg().setRegistryName("spawn_egg")).func_77655_b("spawn_egg").func_77637_a(tab);
        coloredEgg = ((Item)new ItemColoredEgg().setRegistryName("colored_egg")).func_77655_b("colored_egg").func_77637_a(tab);
        liquidEgg = ((Item)new ItemLiquidEgg().setRegistryName("liquid_egg")).func_77655_b("liquid_egg").func_77637_a(tab);
        analyzer = ((Item)new ItemAnalyzer().setRegistryName("analyzer")).func_77655_b("analyzer").func_77637_a(tab);
        henhouse = ((Block)new BlockHenhouse().setRegistryName("henhouse")).func_149663_c("henhouse").func_149647_a(tab);
        henhouse_acacia = ((Block)new BlockHenhouse().setRegistryName("henhouse_acacia")).func_149663_c("henhouse_acacia").func_149647_a(tab);
        henhouse_birch = ((Block)new BlockHenhouse().setRegistryName("henhouse_birch")).func_149663_c("henhouse_birch").func_149647_a(tab);
        henhouse_dark_oak = ((Block)new BlockHenhouse().setRegistryName("henhouse_dark_oak")).func_149663_c("henhouse_dark_oak").func_149647_a(tab);
        henhouse_jungle = ((Block)new BlockHenhouse().setRegistryName("henhouse_jungle")).func_149663_c("henhouse_jungle").func_149647_a(tab);
        henhouse_spruce = ((Block)new BlockHenhouse().setRegistryName("henhouse_spruce")).func_149663_c("henhouse_spruce").func_149647_a(tab);
        guiHandler = new TileEntityGuiHandler();
    }
}

