/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import p455w0rd.wct.api.IWirelessCraftingTermHandler;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;
import p455w0rd.wct.util.WCTUtils;

public class PacketJEIRecipe
extends WCTPacket {
    private ItemStack[][] recipe;

    public PacketJEIRecipe(ByteBuf stream) throws IOException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(stream.array());
        bytes.skip(stream.readerIndex());
        NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
        if (comp != null) {
            this.recipe = new ItemStack[9][];
            for (int x = 0; x < this.recipe.length; ++x) {
                NBTTagList list = comp.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                this.recipe[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    this.recipe[x][y] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(y));
                }
            }
        }
    }

    public PacketJEIRecipe(NBTTagCompound recipe) throws IOException {
        ByteBuf data = Unpooled.buffer();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
        data.writeBytes(bytes.toByteArray());
        this.configureWrite(data);
    }

    private WCTGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WCTGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        EntityPlayerMP pmp = (EntityPlayerMP)player;
        Container con = pmp.field_71070_bA;
        if (con instanceof IContainerCraftingPacket) {
            IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
            IGridNode node = cct.getNetworkNode();
            if (node == null) {
                WCTGuiObject obj = this.getGuiObject(WCTUtils.getWirelessTerm(player.field_71071_by), player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                node = obj.getActionableNode(true);
            }
            if (node != null) {
                Actionable realForFake;
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
                IInventory craftMatrix = cct.getInventoryByName("crafting");
                IInventory playerInventory = cct.getInventoryByName("player");
                Actionable actionable = realForFake = cct.useRealItems() ? Actionable.MODULATE : Actionable.SIMULATE;
                if (inv != null && this.recipe != null && security != null) {
                    ItemStack is;
                    InventoryCrafting testInv = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                    for (int x = 0; x < 9; ++x) {
                        if (this.recipe[x] == null || this.recipe[x].length <= 0) continue;
                        testInv.func_70299_a(x, this.recipe[x][0]);
                    }
                    IRecipe r = Platform.findMatchingRecipe((InventoryCrafting)testInv, (World)pmp.field_70170_p);
                    if (r != null && security.hasPermission(player, SecurityPermissions.EXTRACT) && (is = r.func_77572_b(testInv)) != null) {
                        IMEMonitor storage = inv.getItemInventory();
                        IItemList all = storage.getStorageList();
                        ItemStack[] nullStack = new ItemStack[]{};
                        IPartitionList filter = ItemViewCell.createFilter((ItemStack[])nullStack);
                        for (int x = 0; x < craftMatrix.func_70302_i_(); ++x) {
                            ItemStack patternItem = testInv.func_70301_a(x);
                            ItemStack currentItem = craftMatrix.func_70301_a(x);
                            if (currentItem != null) {
                                AEItemStack in;
                                testInv.func_70299_a(x, currentItem);
                                ItemStack newItemStack = r.func_77569_a(testInv, pmp.field_70170_p) ? r.func_77572_b(testInv) : null;
                                testInv.func_70299_a(x, patternItem);
                                if (!(newItemStack != null && Platform.itemComparisons().isSameItem(newItemStack, is) || (in = AEItemStack.create((ItemStack)currentItem)) == null)) {
                                    IAEItemStack out;
                                    IAEItemStack iAEItemStack = out = realForFake == Actionable.SIMULATE ? null : (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (BaseActionSource)cct.getActionSource());
                                    if (out != null) {
                                        craftMatrix.func_70299_a(x, out.getItemStack());
                                    } else {
                                        craftMatrix.func_70299_a(x, null);
                                    }
                                    currentItem = craftMatrix.func_70301_a(x);
                                }
                            }
                            if (patternItem == null || currentItem != null) continue;
                            ItemStack whichItem = Platform.extractItemsByRecipe((IEnergySource)energy, (BaseActionSource)cct.getActionSource(), (IMEMonitor)storage, (World)player.field_70170_p, (IRecipe)r, (ItemStack)is, (InventoryCrafting)testInv, (ItemStack)patternItem, (int)x, (IItemList)all, (Actionable)realForFake, (IPartitionList)filter);
                            if (whichItem == null) {
                                for (int y = 0; y < this.recipe[x].length; ++y) {
                                    AEItemStack request = AEItemStack.create((ItemStack)this.recipe[x][y]);
                                    if (request == null || filter != null && !filter.isListed((IAEStack)request)) continue;
                                    request.setStackSize(1L);
                                    IAEItemStack out = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (BaseActionSource)cct.getActionSource());
                                    if (out == null) continue;
                                    whichItem = out.getItemStack();
                                    break;
                                }
                            }
                            if (whichItem == null && playerInventory != null) {
                                whichItem = this.extractItemFromPlayerInventory(player, realForFake, patternItem);
                            }
                            craftMatrix.func_70299_a(x, whichItem);
                        }
                        con.func_75130_a(craftMatrix);
                    }
                }
            }
        }
    }

    private ItemStack extractItemFromPlayerInventory(EntityPlayer player, Actionable mode, ItemStack patternItem) {
        boolean checkFuzzy;
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (EnumFacing)EnumFacing.UP);
        AEItemStack request = AEItemStack.create((ItemStack)patternItem);
        boolean isSimulated = mode == Actionable.SIMULATE;
        boolean bl = checkFuzzy = request.isOre() || patternItem.func_77952_i() == Short.MAX_VALUE || patternItem.func_77942_o() || patternItem.func_77984_f();
        if (!checkFuzzy) {
            if (isSimulated) {
                return ia.simulateRemove(1, patternItem, null);
            }
            return ia.removeItems(1, patternItem, null);
        }
        if (isSimulated) {
            return ia.simulateSimilarRemove(1, patternItem, FuzzyMode.IGNORE_ALL, null);
        }
        return ia.removeSimilarItems(1, patternItem, FuzzyMode.IGNORE_ALL, null);
    }
}

