/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import p455w0rd.wct.api.IWirelessCraftingTermHandler;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.api.networking.security.WCTPlayerSource;
import p455w0rd.wct.handlers.GuiHandler;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.items.ItemBase;
import p455w0rd.wct.items.ItemInfinityBooster;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;
import p455w0rd.wct.util.WCTUtils;
import p455w0rdslib.util.EntityItemUtils;
import p455w0rdslib.util.ItemUtils;

public class ItemMagnet
extends ItemBase {
    private int distanceFromPlayer;
    private WCTGuiObject obj;
    private IPortableCell civ;
    private IEnergySource powerSrc;
    private IMEMonitor<IAEItemStack> monitor;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private BaseActionSource mySrc;
    private ItemStack thisItemStack;
    private int pickupTimer = 0;
    private static final String name = "magnet_card";

    public ItemMagnet() {
        super(name);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack item) {
        return this.isActivated(item);
    }

    public void setItemStack(ItemStack is) {
        this.thisItemStack = is;
    }

    public boolean func_77645_m() {
        return false;
    }

    public ItemStack getItemStack() {
        if (this.thisItemStack != null && this.thisItemStack.func_77973_b() instanceof ItemMagnet) {
            return this.thisItemStack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List<String> list, boolean par4) {
        list.add(this.color("aqua") + "==============================");
        String shift = I18n.func_135052_a((String)"tooltip.press_shift.desc", (Object[])new Object[0]).replace("Shift", this.color("yellow") + this.color("bold") + this.color("italics") + "Shift" + this.color("gray"));
        if (ItemMagnet.isShiftKeyDown()) {
            ItemStack itemStack = this.getItemStack();
            String info = I18n.func_135052_a((String)"tooltip.magnet.desc", (Object[])new Object[0]);
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)info, (int)37, (String)"\n", (boolean)false))) {
                list.add(line.trim());
            }
            list.add("");
            list.add(this.color("italics") + "" + I18n.func_135052_a((String)"tooltip.magnet_set_filter.desc", (Object[])new Object[0]));
            if (this.isActivated(itemStack)) {
                String boundKey2;
                String boundKey = Keyboard.getKeyName((int)ModKeybindings.openMagnetFilter.func_151463_i());
                if (!boundKey.equals("NONE")) {
                    list.add(this.color("italics") + I18n.func_135052_a((String)"tooltip.or_press.desc", (Object[])new Object[0]) + " " + this.color("yellow") + this.color("bold") + "[" + boundKey + "]");
                }
                if (!(boundKey2 = Keyboard.getKeyName((int)ModKeybindings.changeMagnetMode.func_151463_i())).equals("NONE")) {
                    list.add(this.color("italics") + I18n.func_135052_a((String)"tooltip.press.desc", (Object[])new Object[0]) + " " + this.color("yellow") + this.color("bold") + "[" + boundKey2 + "] " + this.color("gray") + this.color("italics") + I18n.func_135052_a((String)"tooltip.to_switch.desc", (Object[])new Object[0]));
                }
            }
            list.add("");
            list.add(I18n.func_135052_a((String)"tooltip.status.desc", (Object[])new Object[0]) + ": " + (this.isActivated(is) ? this.color("green") + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0]) : this.color("red") + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0])));
            if (is.func_77952_i() == 1) {
                list.add(this.color("white") + "  " + I18n.func_135052_a((String)"tooltip.magnet_active_1.desc", (Object[])new Object[0]));
            } else if (is.func_77952_i() == 2) {
                list.add(this.color("white") + "  " + I18n.func_135052_a((String)"tooltip.magnet_active_2.desc", (Object[])new Object[0]));
            }
            String white = I18n.func_135052_a((String)"tooltip.magnet_whitelisting.desc", (Object[])new Object[0]);
            String black = I18n.func_135052_a((String)"tooltip.magnet_blacklisting.desc", (Object[])new Object[0]);
            list.add(I18n.func_135052_a((String)"tooltip.filter_mode.desc", (Object[])new Object[0]) + ": " + this.color("white") + (this.getMode(is) ? white : black));
            String not = I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0]);
            String ignoring = I18n.func_135052_a((String)"tooltip.ignoring.desc", (Object[])new Object[0]);
            String nbtData = I18n.func_135052_a((String)"tooltip.nbt.desc", (Object[])new Object[0]);
            String metaData = I18n.func_135052_a((String)"tooltip.meta.desc", (Object[])new Object[0]);
            String usingOreDict = I18n.func_135052_a((String)"tooltip.using.desc", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tooltip.oredict.desc", (Object[])new Object[0]);
            list.add((!this.doesMagnetUseOreDict() ? " " + not : this.color("green")) + " " + usingOreDict);
            list.add((!this.doesMagnetIgnoreNBT() ? " " + not : this.color("green")) + " " + ignoring + " " + nbtData);
            list.add((!this.doesMagnetIgnoreMeta() ? " " + not : this.color("green")) + " " + ignoring + " " + metaData);
            List<ItemStack> filteredItems = this.getFilteredItems(itemStack);
            if (filteredItems != null) {
                list.add("");
                list.add(this.color("gray") + I18n.func_135052_a((String)"tooltip.filtered_items.desc", (Object[])new Object[0]) + ":");
                for (int i = 0; i < filteredItems.size(); ++i) {
                    list.add("  " + filteredItems.get(i).func_82833_r());
                }
            }
            list.add("");
            String onlyWorks = I18n.func_135052_a((String)"tooltip.only_works.desc", (Object[])new Object[0]);
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)onlyWorks, (int)27, (String)"\n", (boolean)false))) {
                list.add(this.color("white") + this.color("bold") + this.color("italics") + line.trim());
            }
        } else {
            list.add(shift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String color(String color) {
        return WCTUtils.color(color);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.switchMagnetMode(item, player);
            } else {
                if (!WCTUtils.isMagnetInitialized(item)) {
                    NetworkHandler.instance().sendToServer(new PacketMagnetFilter(0, true));
                }
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                GuiHandler.open(4, player, world, new BlockPos(x, y, z));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        if (player.func_70093_af()) {
            this.switchMagnetMode(item, player);
            this.displayMessage(item.func_77952_i());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)item);
    }

    @SideOnly(value=Side.CLIENT)
    public void displayMessage(int mode) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        switch (mode) {
            case 1: {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"chatmessages.magnet_activated.desc", (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"tooltip.magnet_active_1.desc", (Object[])new Object[0])));
                break;
            }
            case 2: {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"chatmessages.magnet_activated.desc", (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"tooltip.magnet_active_2.desc", (Object[])new Object[0])));
                break;
            }
            case 0: {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"chatmessages.magnet_deactivated.desc", (Object[])new Object[0])));
            }
        }
    }

    public void switchMagnetMode(ItemStack item, EntityPlayer player) {
        if (item.func_77952_i() == 0) {
            item.func_77964_b(1);
        } else if (item.func_77952_i() == 1) {
            item.func_77964_b(2);
        } else {
            item.func_77964_b(0);
        }
    }

    public void doMagnet(ItemStack item, World world, EntityPlayer player, ItemStack wirelessTerm) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getItemStack() == null) {
            return;
        }
        if (!this.isActivated(item)) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            return;
        }
        this.distanceFromPlayer = 6;
        List<ItemStack> filteredList = this.getFilteredItems(this.getItemStack());
        for (EntityItem itemToGet : ItemMagnet.getEntitiesInRange(EntityItem.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, this.distanceFromPlayer)) {
            if (itemToGet == null) {
                return;
            }
            if (EntityItemUtils.getThrowerName((EntityItem)itemToGet) != null && EntityItemUtils.getThrowerName((EntityItem)itemToGet).equals(player.func_70005_c_()) && !EntityItemUtils.canPickup((EntityItem)itemToGet)) continue;
            EntityItemPickupEvent pickupEvent = new EntityItemPickupEvent(player, itemToGet);
            PlayerEvent.ItemPickupEvent itemPickupEvent = new PlayerEvent.ItemPickupEvent(player, itemToGet);
            ItemStack itemStackToGet = itemToGet.func_92059_d();
            if (itemStackToGet == null) {
                return;
            }
            int stackSize = itemStackToGet.field_77994_a;
            MinecraftForge.EVENT_BUS.post((Event)pickupEvent);
            if (this.obj == null) {
                this.obj = this.getGuiObject(wirelessTerm, player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                this.civ = this.obj;
                this.powerSrc = this.civ;
                this.monitor = this.civ.getItemInventory();
                this.cellInv = this.monitor;
                this.mySrc = new WCTPlayerSource(player, this.obj);
            }
            boolean ignoreRange = this.isBoosterInstalled(wirelessTerm) && ModConfig.WCT_BOOSTER_ENABLED;
            boolean hasAxxess = this.hasNetworkAccess(SecurityPermissions.INJECT, true, player, wirelessTerm);
            if (ignoreRange && hasAxxess || this.obj.rangeCheck() && hasAxxess) {
                IAEItemStack ais = AEApi.instance().storage().createItemStack(itemStackToGet);
                ais.setStackSize((long)stackSize);
                if (itemToGet.field_70128_L) continue;
                if (this.getMode(this.getItemStack())) {
                    if (this.isItemFiltered(itemStackToGet, filteredList) && filteredList != null && filteredList.size() > 0) {
                        if (!this.doInject(ais, stackSize, player, itemToGet, itemStackToGet, world)) continue;
                        itemToGet.func_70106_y();
                        continue;
                    }
                    if (item.func_77952_i() == 1) {
                        if (pickupEvent.getResult() != Event.Result.ALLOW && itemPickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && !player.field_71071_by.func_70441_a(itemStackToGet)) continue;
                        player.func_71001_a((Entity)itemToGet, stackSize);
                        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                        continue;
                    }
                    this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
                    continue;
                }
                if (!this.isItemFiltered(itemStackToGet, filteredList) || filteredList == null || filteredList.size() <= 0) {
                    if (!this.doInject(ais, stackSize, player, itemToGet, itemStackToGet, world)) continue;
                    itemToGet.func_70106_y();
                    continue;
                }
                if (item.func_77952_i() == 1) {
                    if (pickupEvent.getResult() != Event.Result.ALLOW && itemPickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && !player.field_71071_by.func_70441_a(itemStackToGet)) continue;
                    player.func_71001_a((Entity)itemToGet, stackSize);
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                    continue;
                }
                this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
                continue;
            }
            this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
        }
        for (EntityXPOrb xpToGet : ItemMagnet.getEntitiesInRange(EntityXPOrb.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, this.distanceFromPlayer)) {
            if (xpToGet.field_70128_L || xpToGet.func_82150_aj()) continue;
            int xpAmount = xpToGet.field_70530_e;
            xpToGet.field_70530_e = 0;
            player.field_71090_bL = 0;
            player.func_71023_q(xpAmount);
            xpToGet.func_70106_y();
            xpToGet.func_82142_c(true);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
    }

    private void doVanillaPickup(EntityItem itemToGet, EntityPlayer player, ItemStack itemStackToGet, World world, int stackSize) {
        if (this.pickupTimer < 100) {
            ++this.pickupTimer;
            return;
        }
        this.pickupTimer = 0;
        if (itemToGet.func_70032_d((Entity)player) <= 2.0f && player.field_71071_by.func_70441_a(itemStackToGet)) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
    }

    private boolean doesMagnetIgnoreNBT() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"IgnoreNBT");
    }

    private boolean doesMagnetIgnoreMeta() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"IgnoreMeta");
    }

    private boolean doesMagnetUseOreDict() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"UseOreDict");
    }

    private boolean areOresEqual(ItemStack is1, ItemStack is2) {
        int[] list1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] list2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int element : list1) {
            for (int element2 : list2) {
                if (element != element2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemFiltered(ItemStack is, List<ItemStack> itemList) {
        if (is != null && itemList != null) {
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack thisStack = itemList.get(i);
                if (this.doesMagnetUseOreDict() && this.areOresEqual(is, thisStack)) {
                    return true;
                }
                if (!(this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() ? is.func_77973_b().equals(thisStack.func_77973_b()) : (this.doesMagnetIgnoreMeta() && !this.doesMagnetIgnoreNBT() ? ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b() : (!this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() && is.func_77973_b() == thisStack.func_77973_b() ? this.isMetaEqual(is, thisStack) : this.isMetaEqual(is, thisStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b())))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMetaEqual(ItemStack is1, ItemStack is2) {
        return is1.func_77952_i() == is2.func_77952_i();
    }

    private boolean hasNetworkAccess(SecurityPermissions perm, boolean requirePower, EntityPlayer player, ItemStack wirelessTerm) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IGrid g = this.obj.getTargetGrid();
        if (g != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(player, perm)) {
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> getFilteredItems(ItemStack magnetItem) {
        if (magnetItem == null) {
            return null;
        }
        if (magnetItem.func_77973_b() instanceof ItemMagnet && magnetItem.func_77942_o()) {
            NBTTagCompound nbtTC = magnetItem.func_77978_p();
            if (!nbtTC.func_74764_b("MagnetFilter")) {
                return null;
            }
            NBTTagList tagList = nbtTC.func_150295_c("MagnetFilter", 10);
            if (tagList.func_74745_c() > 0 && tagList != null) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    itemList.add(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i)));
                }
                return itemList;
            }
        }
        return null;
    }

    private boolean doInject(IAEItemStack ais, int stackSize, EntityPlayer player, EntityItem itemToGet, ItemStack itemStackToGet, World world) {
        if ((ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.powerSrc, this.cellInv, (IAEStack)ais, (BaseActionSource)this.mySrc)) != null && WCTUtils.getMagnet(player.field_71071_by) != null && WCTUtils.getMagnet(player.field_71071_by).func_77952_i() != 2) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            player.field_71071_by.func_70441_a(itemStackToGet);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
        return ais == null;
    }

    private boolean isBoosterInstalled(ItemStack wirelessTerm) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        if (wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem && wirelessTerm.func_77942_o() && (boosterNBTList = wirelessTerm.func_77978_p().func_150295_c("BoosterSlot", 10)) != null && (boosterTagCompound = boosterNBTList.func_150305_b(0)) != null && (boosterCard = ItemStack.func_77949_a((NBTTagCompound)boosterTagCompound)) != null) {
            return boosterCard.func_77973_b() instanceof ItemInfinityBooster;
        }
        return false;
    }

    private boolean getMode(ItemStack magnetItem) {
        NBTTagCompound nbtTC;
        if (magnetItem.func_77973_b() instanceof ItemMagnet && magnetItem.func_77942_o() && (nbtTC = magnetItem.func_77978_p()).func_74764_b("Whitelisting")) {
            return nbtTC.func_74767_n("Whitelisting");
        }
        return true;
    }

    private WCTGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WCTGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public static List<?> getEntitiesInRange(Class<? extends Entity> entityType, World world, int x, int y, int z, int distance) {
        return world.func_72872_a(entityType, new AxisAlignedBB((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + distance), (double)(y + distance), (double)(z + distance)));
    }

    public ItemStack getStack() {
        return this.getStack(1);
    }

    public ItemStack getStack(int size) {
        return new ItemStack((Item)this, size);
    }

    protected boolean isActivated(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.func_77952_i() != 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < 3; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }
}

