/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import p455w0rd.wct.api.networking.security.WCTIActionHost;
import p455w0rd.wct.api.networking.security.WCTPlayerSource;
import p455w0rd.wct.container.CraftingCPURecord;
import p455w0rd.wct.container.WCTBaseContainer;
import p455w0rd.wct.container.guisync.GuiSync;
import p455w0rd.wct.handlers.GuiHandler;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wct.sync.packets.PacketSetJobBytes;
import p455w0rd.wct.sync.packets.PacketSwitchGuis;
import p455w0rd.wct.sync.packets.PacketUpdateCPUInfo;

public class ContainerCraftConfirm
extends WCTBaseContainer {
    public final ArrayList<CraftingCPURecord> cpus = new ArrayList();
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";
    InventoryPlayer inventoryPlayer;

    public ContainerCraftConfirm(InventoryPlayer ip, ITerminalHost te) {
        super(ip, te);
        this.inventoryPlayer = ip;
    }

    public void cycleCpu(boolean next) {
        if (next) {
            this.setSelectedCpu(this.getSelectedCpu() + 1);
        } else {
            this.setSelectedCpu(this.getSelectedCpu() - 1);
        }
        if (this.getSelectedCpu() < -1) {
            this.setSelectedCpu(this.cpus.size() - 1);
        } else if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
        }
        if (this.getSelectedCpu() == -1) {
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
            try {
                NetworkHandler.instance().sendTo(new PacketUpdateCPUInfo(0, 0), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {}
        } else {
            this.setName(this.cpus.get(this.getSelectedCpu()).getName());
            this.setCpuAvailableBytes(this.cpus.get(this.getSelectedCpu()).getSize());
            this.setCpuCoProcessors(this.cpus.get(this.getSelectedCpu()).getProcessors());
            try {
                NetworkHandler.instance().sendTo(new PacketUpdateCPUInfo((int)this.getCpuAvailableBytes(), this.getCpuCoProcessors()), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
        ImmutableSet cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (ccr.getCpu() != c) continue;
                found = true;
            }
            boolean matched = this.cpuMatches(c);
            if (matched) {
                ++matches;
            }
            if (found != !matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.setNoCPU(this.cpus.isEmpty());
        super.func_75142_b();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                if (!this.result.isSimulation()) {
                    this.setSimulation(false);
                    if (this.isAutoStart()) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.setSimulation(true);
                }
                try {
                    PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                    PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                    PacketMEInventoryUpdate c = this.result.isSimulation() ? new PacketMEInventoryUpdate(2) : null;
                    IItemList plan = AEApi.instance().storage().createItemList();
                    this.result.populatePlan(plan);
                    try {
                        NetworkHandler.instance().sendTo(new PacketSetJobBytes((int)this.result.getByteTotal()), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.setUsedBytes(this.result.getByteTotal());
                    for (IAEItemStack out : plan) {
                        IAEItemStack o = out.copy();
                        o.reset();
                        o.setStackSize(out.getStackSize());
                        IAEItemStack p = out.copy();
                        p.reset();
                        p.setStackSize(out.getCountRequestable());
                        IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                        IMEMonitor items = sg.getItemInventory();
                        IAEItemStack m = null;
                        if (c != null && this.result.isSimulation()) {
                            m = o.copy();
                            if ((o = (IAEItemStack)items.extractItems((IAEStack)o, Actionable.SIMULATE, this.getActionSource())) == null) {
                                o = m.copy();
                                o.setStackSize(0L);
                            }
                            m.setStackSize(m.getStackSize() - o.getStackSize());
                        }
                        if (o.getStackSize() > 0L) {
                            a.appendItem(o);
                        }
                        if (p.getStackSize() > 0L) {
                            b.appendItem(p);
                        }
                        if (c == null || m == null || m.getStackSize() <= 0L) continue;
                        c.appendItem(m);
                    }
                    for (Object g : this.field_75149_d) {
                        if (!(g instanceof EntityPlayer)) continue;
                        NetworkHandler.instance().sendTo(a, (EntityPlayerMP)g);
                        NetworkHandler.instance().sendTo(b, (EntityPlayerMP)g);
                        if (c == null) continue;
                        NetworkHandler.instance().sendTo(c, (EntityPlayerMP)g);
                    }
                }
                catch (IOException a) {
                }
            }
            catch (Throwable e) {
                this.getPlayerInv().field_70458_d.func_145747_a((ITextComponent)new TextComponentString("Error: " + e.toString()));
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        WCTIActionHost h = (WCTIActionHost)this.getTarget();
        return h.getActionableNode(true).getGrid();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.getUsedBytes() && !c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else if (this.getSelectedCpu() != -1) {
            this.setName(this.cpus.get(this.getSelectedCpu()).getName());
            this.setCpuAvailableBytes(this.cpus.get(this.getSelectedCpu()).getSize());
            this.setCpuCoProcessors(this.cpus.get(this.getSelectedCpu()).getProcessors());
        }
    }

    public void startJob() {
        int originalGui = 0;
        WCTIActionHost ah = this.getActionHost();
        if (ah instanceof WCTGuiObject) {
            originalGui = 0;
        }
        if (this.result != null && !this.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.getSelectedCpu() == -1 ? null : this.cpus.get(this.getSelectedCpu()).getCpu(), true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui == 0) {
                NetworkHandler.instance().sendTo(new PacketSwitchGuis(originalGui), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                EntityPlayerMP player = (EntityPlayerMP)this.getInventoryPlayer().field_70458_d;
                World world = player.field_70170_p;
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                GuiHandler.open(originalGui, (EntityPlayer)player, world, new BlockPos(x, y, z));
            }
        }
    }

    private BaseActionSource getActionSrc() {
        return new WCTPlayerSource(this.getPlayerInv().field_70458_d, (WCTIActionHost)this.getTarget());
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public World getWorld() {
        return this.getPlayerInv().field_70458_d.field_70170_p;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getUsedBytes() {
        return this.bytesUsed;
    }

    private void setUsedBytes(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    private void setCpuAvailableBytes(long cpuBytesAvail) {
        this.cpuBytesAvail = cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    private void setCpuCoProcessors(int cpuCoProcessors) {
        this.cpuCoProcessors = cpuCoProcessors;
    }

    public int getSelectedCpu() {
        return this.selectedCpu;
    }

    private void setSelectedCpu(int selectedCpu) {
        this.selectedCpu = selectedCpu;
    }

    public String getName() {
        return this.myName;
    }

    private void setName(@Nonnull String myName) {
        this.myName = myName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    private void setNoCPU(boolean noCPU) {
        this.noCPU = noCPU;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    private void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public Future<ICraftingJob> getJob() {
        return this.job;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }
}

