/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import p455w0rd.wct.client.gui.widgets.WCTGuiButton;
import p455w0rd.wct.client.gui.widgets.WCTGuiCheckBox;
import p455w0rd.wct.container.ContainerMagnet;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;

public class GuiMagnet
extends GuiContainer {
    private WCTGuiButton modeBtn;
    public boolean mode = true;
    public boolean ignoreNBT = false;
    public boolean ignoreMeta = false;
    public boolean useOreDict = false;
    private ItemStack magnetItem;
    private WCTGuiCheckBox ignoreNBTBox;
    private WCTGuiCheckBox ignoreMetaBox;
    private WCTGuiCheckBox useOreDictBox;

    public GuiMagnet(ContainerMagnet c) {
        super((Container)c);
        this.field_146294_l = this.field_146999_f = 176;
        this.field_146295_m = this.field_147000_g = 208;
        this.magnetItem = c.magnetItem;
        this.loadSettings();
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        this.bindTexture("magnetfilter.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 208);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.title.magnet_filter", (Object[])new Object[0]), 7, 5, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 7, 114, 0x404040);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.modeBtn = new WCTGuiButton(0, this.field_147003_i + 104, this.field_147009_r + 4, 64, 14, this.getLabel(this.mode));
        this.field_146292_n.add(this.modeBtn);
        this.ignoreNBTBox = new WCTGuiCheckBox(1, this.field_147003_i + 61, this.field_147009_r + 20, "Ignore NBT Data", this.ignoreNBT, 107);
        this.field_146292_n.add(this.ignoreNBTBox);
        this.ignoreMetaBox = new WCTGuiCheckBox(2, this.field_147003_i + 61, this.field_147009_r + 32, "Ignore Meta Data", this.ignoreMeta, 107);
        this.field_146292_n.add(this.ignoreMetaBox);
        this.useOreDictBox = new WCTGuiCheckBox(3, this.field_147003_i + 61, this.field_147009_r + 44, "Use Ore Dictionary", this.useOreDict, 107);
        this.field_146292_n.add(this.useOreDictBox);
    }

    String getLabel(boolean filterMode) {
        return filterMode ? "Whitelisting" : "Blacklisting";
    }

    private void loadSettings() {
        if (this.magnetItem == null) {
            return;
        }
        if (!this.magnetItem.func_77942_o()) {
            NetworkHandler.instance().sendToServer(new PacketMagnetFilter(0, false));
        }
        this.mode = this.getMode(1);
        this.ignoreNBT = this.getMode(2);
        this.ignoreMeta = this.getMode(3);
        this.useOreDict = this.getMode(4);
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.modeBtn) {
            btn.field_146126_j = this.getLabel(!this.mode);
            this.mode = !this.mode;
            this.updateMode(1, this.mode);
        } else if (btn == this.ignoreNBTBox) {
            this.ignoreNBT = !this.ignoreNBT;
            this.updateMode(2, this.ignoreNBT);
        } else if (btn == this.ignoreMetaBox) {
            this.ignoreMeta = !this.ignoreMeta;
            this.updateMode(3, this.ignoreMeta);
        } else if (btn == this.useOreDictBox) {
            this.useOreDict = !this.useOreDict;
            this.updateMode(4, this.useOreDict);
        } else {
            return;
        }
    }

    private void updateMode(int type, boolean mode) {
        NetworkHandler.instance().sendToServer(new PacketMagnetFilter(type, mode));
    }

    private boolean getMode(int type) {
        NBTTagCompound nbtTC = this.magnetItem.func_77978_p();
        if (type == 1) {
            if (nbtTC.func_74764_b("Whitelisting")) {
                return nbtTC.func_74767_n("Whitelisting");
            }
            return true;
        }
        if (type == 2) {
            if (nbtTC.func_74764_b("IgnoreNBT")) {
                return nbtTC.func_74767_n("IgnoreNBT");
            }
            return false;
        }
        if (type == 3) {
            if (nbtTC.func_74764_b("IgnoreMeta")) {
                return nbtTC.func_74767_n("IgnoreMeta");
            }
            return false;
        }
        if (type == 4) {
            if (nbtTC.func_74764_b("UseOreDict")) {
                return nbtTC.func_74767_n("UseOreDict");
            }
            return false;
        }
        return true;
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("wct", "textures/gui/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }
}

