/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.IModObject;
import crazypants.enderio.capability.InventorySlot;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.DefaultCapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.IEnergyStorage;

@Storable
public class EnergyTank
implements IEnergyStorage {
    @Nonnull
    private ICapacitorData capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
    @Nonnull
    private final ICapacitorKey maxEnergyRecieved;
    @Nonnull
    private final ICapacitorKey maxEnergyStored;
    @Nonnull
    private final ICapacitorKey maxEnergyUsed;
    @Nullable
    TileEntity owner = null;
    @Store
    private int storedEnergy;

    public IEnergyStorage get(EnumFacing side) {
        if (side != null && this.owner instanceof AbstractMachineEntity) {
            return new Side(side);
        }
        return this;
    }

    public EnergyTank(TileEntity owner, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this.owner = owner;
        this.maxEnergyRecieved = maxEnergyRecieved;
        this.maxEnergyStored = maxEnergyStored;
        this.maxEnergyUsed = maxEnergyUsed;
    }

    public EnergyTank(TileEntity owner, IModObject modObject) {
        this.owner = owner;
        this.maxEnergyRecieved = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, 80);
        this.maxEnergyStored = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, 100000);
        this.maxEnergyUsed = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, 20);
    }

    public EnergyTank(TileEntity owner) {
        this.owner = owner;
        this.maxEnergyRecieved = CapacitorKey.LEGACY_ENERGY_INTAKE;
        this.maxEnergyStored = CapacitorKey.LEGACY_ENERGY_BUFFER;
        this.maxEnergyUsed = CapacitorKey.LEGACY_ENERGY_USE;
    }

    public boolean updateCapacitorFromSlot(InventorySlot slot) {
        ICapacitorData newData;
        int oldValue = this.maxEnergyStored.get(this.capacitorData);
        this.capacitorData = slot == null || Prep.isInvalid(slot.getStackInSlot(0)) ? DefaultCapacitorData.BASIC_CAPACITOR : ((newData = CapacitorHelper.getCapacitorDataFromItemStack(slot.getStackInSlot(0))) == null ? DefaultCapacitorData.BASIC_CAPACITOR : newData);
        if (oldValue != this.maxEnergyStored.get(this.capacitorData) || this.getEnergyStored() > oldValue) {
            this.setEnergyStored(this.getEnergyStored());
            return true;
        }
        return false;
    }

    private void onChange() {
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }

    public int getMaxEnergyRecieved() {
        return this.maxEnergyRecieved.get(this.capacitorData);
    }

    public boolean useEnergy() {
        int toUse = this.maxEnergyUsed.get(this.capacitorData);
        if (toUse <= this.getEnergyStored()) {
            this.setEnergyStored(this.getEnergyStored() - toUse);
            return true;
        }
        return false;
    }

    private void setEnergyStored(int stored) {
        int newEnergy = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
        if (newEnergy != this.storedEnergy) {
            this.storedEnergy = newEnergy;
            this.onChange();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int result = Math.max(0, Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxEnergyRecieved(), maxReceive)));
        if (result > 0 && !simulate) {
            this.setEnergyStored(this.getEnergyStored() + result);
        }
        return result;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyStored.get(this.capacitorData);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public ICapacitorData getCapacitorData() {
        return this.capacitorData;
    }

    private class Side
    implements IEnergyStorage {
        private final EnumFacing side;

        public Side(EnumFacing side) {
            this.side = side;
        }

        private boolean isEnabled() {
            if (EnergyTank.this.owner != null) {
                switch (((AbstractMachineEntity)EnergyTank.this.owner).getIoMode(this.side)) {
                    case DISABLED: 
                    case PUSH: {
                        return false;
                    }
                    case NONE: 
                    case PULL: 
                    case PUSH_PULL: {
                        return true;
                    }
                }
            }
            throw new RuntimeException("The fat lady has sung.");
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.isEnabled()) {
                return EnergyTank.this.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.isEnabled()) {
                return EnergyTank.this.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.isEnabled()) {
                return EnergyTank.this.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.isEnabled()) {
                return EnergyTank.this.getMaxEnergyStored();
            }
            return 0;
        }

        public boolean canExtract() {
            if (this.isEnabled()) {
                return EnergyTank.this.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            if (this.isEnabled()) {
                return EnergyTank.this.canReceive();
            }
            return false;
        }
    }
}

