/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.ModObject;
import crazypants.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public enum Alloy implements IStringSerializable
{
    ELECTRICAL_STEEL("electricalSteel", 6.0f, 0xA9A9A9, 1202),
    ENERGETIC_ALLOY("energeticAlloy", 7.0f, 14259020, 855),
    VIBRANT_ALLOY("vibrantAlloy", 4.0f, 11978864, 640),
    REDSTONE_ALLOY("redstoneAlloy", 1.0f, 11609895, 1084),
    CONDUCTIVE_IRON("conductiveIron", 5.2f, 11230559, 1127),
    PULSATING_IRON("pulsatingIron", 7.0f, 2920516, 1132),
    DARK_STEEL("darkSteel", 10.0f, 0x6C6C6C, 1540),
    SOULARIUM("soularium", 10.0f, 6904653, 363);

    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    @Nonnull
    public final String iconKey;
    @Nonnull
    private final List<String> oreIngots = new ArrayList<String>();
    @Nonnull
    private final List<String> oreBlocks = new ArrayList<String>();
    private final float hardness;
    private final int color;
    private final int meltingPoint;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(Alloy.values().length);
        for (Alloy a : Alloy.values()) {
            res.add(new ResourceLocation(a.iconKey));
        }
        return res;
    }

    private Alloy(@Nullable String baseName, float hardness, String oreDictName, int color, int meltingPoint) {
        this.baseName = baseName;
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        if (oreDictName != null) {
            this.oreIngots.add("ingot" + StringUtils.capitalize((String)oreDictName));
            this.oreBlocks.add("block" + StringUtils.capitalize((String)oreDictName));
        }
        this.oreIngots.add("ingot" + StringUtils.capitalize((String)baseName));
        this.oreBlocks.add("block" + StringUtils.capitalize((String)baseName));
        this.hardness = hardness;
        this.color = color;
        this.meltingPoint = meltingPoint;
    }

    private Alloy(String baseName, float hardness, int color, int meltingPoint) {
        this(baseName, hardness, null, color, meltingPoint);
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    @Nonnull
    public String getFluidName() {
        return NullHelper.notnullJ(this.baseName.toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
    }

    public float getHardness() {
        return this.hardness;
    }

    public int getColor() {
        return this.color;
    }

    public int getMeltingPoint() {
        return this.meltingPoint;
    }

    @Nonnull
    public ItemStack getStackIngot() {
        return this.getStackIngot(1);
    }

    @Nonnull
    public ItemStack getStackIngot(int size) {
        return new ItemStack(ModObject.itemAlloy.getItem(), size, this.ordinal());
    }

    @Nonnull
    public ItemStack getStackBlock() {
        return this.getStackBlock(1);
    }

    @Nonnull
    public ItemStack getStackBlock(int size) {
        return new ItemStack(ModObject.blockIngotStorage.getBlock(), size, this.ordinal());
    }

    @Nonnull
    public String getOreIngot() {
        return NullHelper.notnull(this.oreIngots.get(0), "Data corruption");
    }

    @Nonnull
    public String getOreBlock() {
        return NullHelper.notnull(this.oreBlocks.get(0), "Data corruption");
    }

    @Nonnull
    public List<String> getOreIngots() {
        return this.oreIngots;
    }

    @Nonnull
    public List<String> getOreBlocks() {
        return this.oreBlocks;
    }

    @Nonnull
    public String func_176610_l() {
        return NullHelper.notnullJ(this.baseName.toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
    }

    @Nonnull
    public static Alloy getTypeFromMeta(int meta) {
        return NullHelper.notnullJ(Alloy.values()[meta >= 0 && meta < Alloy.values().length ? meta : 0], "Enum.values()");
    }

    public static int getMetaFromType(Alloy value) {
        return value.ordinal();
    }
}

