/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.gui.ListSelectionListener;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.ColorUtil;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ClientChannelRegister;
import crazypants.enderio.machine.transceiver.PacketAddRemoveChannel;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannel;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiChannelList;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.UserIdent;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChannelTab
implements ITabPanel {
    protected static final int ADD_BUTTON_ID = 3;
    protected static final int PRIVATE_BUTTON_ID = 4;
    private static final int DELETE_CHANNEL_BUTTON_ID = 5;
    private static final int SEND_BUTTON_ID = 6;
    private static final int RECIEVE_BUTTON_ID = 7;
    ChannelType type;
    GuiTransceiver parent;
    IconButton addButton;
    ToggleButton privateButton;
    GuiTextField newChannelTF;
    GuiChannelList channelList;
    GuiChannelList sendChannels;
    GuiChannelList recieveChannels;
    IconButton deleteChannelB;
    IconButton sendB;
    IconButton recieveB;
    ListSelectionListener<Channel> selectionListener;
    TileTransceiver transceiver;

    public ChannelTab(GuiTransceiver guiTransceiver, ChannelType type) {
        this.parent = guiTransceiver;
        this.type = type;
        this.transceiver = guiTransceiver.getTransciever();
        this.newChannelTF = new GuiTextField(76543, this.parent.getFontRenderer(), 7, 12, 103, 16);
        this.addButton = new IconButton((IGuiScreen)this.parent, 3, 137, 12, (IWidgetIcon)IconEIO.PLUS);
        this.addButton.setToolTip(new String[]{EnderIO.lang.localize("gui.trans.addChannel")});
        this.addButton.field_146124_l = false;
        this.privateButton = new ToggleButton((IGuiScreen)this.parent, 4, 118, 12, (IWidgetIcon)IconEIO.LOCK_UNLOCKED, (IWidgetIcon)IconEIO.LOCK_LOCKED);
        this.privateButton.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.trans.privateChannel")});
        this.privateButton.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.trans.publicChannel")});
        int w = 104;
        int h = 90;
        int x = 7;
        int y = 48;
        this.channelList = new GuiChannelList(this.parent, w, h, x, y);
        this.channelList.setChannels(ClientChannelRegister.instance.getChannelsForType(type), (Predicate<Channel>)Predicates.alwaysTrue());
        this.channelList.setShowSelectionBox(true);
        this.channelList.setScrollButtonIds(100, 101);
        this.deleteChannelB = new IconButton((IGuiScreen)this.parent, 5, x + w - 20, y + h + 4, (IWidgetIcon)IconEIO.MINUS);
        this.deleteChannelB.setToolTip(new String[]{EnderIO.lang.localize("gui.trans.deleteChannel")});
        Predicate<Channel> predicate = new Predicate<Channel>(){

            public boolean apply(@Nullable Channel input) {
                return input != null && (input.isPublic() || input.getUser().equals(EnderIO.proxy.getClientPlayer().func_146103_bH()) || input.getUser() == UserIdent.nobody);
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        };
        h = 35;
        this.sendChannels = new GuiChannelList(this.parent, w, h, x += w + 32, y);
        this.sendChannels.setChannels(this.transceiver.getSendChannels(type), predicate);
        this.sendChannels.setShowSelectionBox(true);
        this.sendChannels.setScrollButtonIds(200, 201);
        this.sendB = new IconButton((IGuiScreen)this.parent, 6, x - 24, y + h / 2 - 9, (IWidgetIcon)IconEIO.ARROWS);
        this.recieveChannels = new GuiChannelList(this.parent, w, h, x, y += h + 20);
        this.recieveChannels.setChannels(this.transceiver.getRecieveChannels(type), predicate);
        this.recieveChannels.setShowSelectionBox(true);
        this.recieveChannels.setScrollButtonIds(300, 301);
        this.recieveB = new IconButton((IGuiScreen)this.parent, 7, x - 24, y + h / 2 - 9, (IWidgetIcon)IconEIO.ARROWS);
        this.selectionListener = new ListSelectionListener<Channel>(){

            public void selectionChanged(GuiScrollableList<Channel> list, int selectedIndex) {
                if (selectedIndex < 0) {
                    return;
                }
                if (list != ChannelTab.this.channelList) {
                    ChannelTab.this.channelList.setSelection(-1);
                }
                if (list != ChannelTab.this.sendChannels) {
                    ChannelTab.this.sendChannels.setSelection(-1);
                }
                if (list != ChannelTab.this.recieveChannels) {
                    ChannelTab.this.recieveChannels.setSelection(-1);
                }
            }
        };
        this.channelList.addSelectionListener(this.selectionListener);
        this.sendChannels.addSelectionListener(this.selectionListener);
        this.recieveChannels.addSelectionListener(this.selectionListener);
    }

    public void onGuiInit(int x, int y, int width, int height) {
        this.addButton.onGuiInit();
        this.privateButton.onGuiInit();
        this.deleteChannelB.onGuiInit();
        this.sendB.onGuiInit();
        this.recieveB.onGuiInit();
        y = this.parent.getGuiTop() + 12;
        this.newChannelTF.field_146209_f = x = this.parent.getGuiLeft() + 8;
        this.newChannelTF.field_146210_g = y;
        this.newChannelTF.func_146205_d(false);
        this.newChannelTF.func_146203_f(32);
        this.newChannelTF.func_146195_b(true);
        this.channelList.onGuiInit((IGuiScreen)this.parent);
        this.sendChannels.onGuiInit((IGuiScreen)this.parent);
        this.recieveChannels.onGuiInit((IGuiScreen)this.parent);
    }

    public void deactivate() {
        this.addButton.detach();
        this.privateButton.detach();
        this.deleteChannelB.detach();
        this.sendB.detach();
        this.recieveB.detach();
    }

    public void keyTyped(char par1, int par2) {
        this.newChannelTF.func_146201_a(par1, par2);
        this.addButton.field_146124_l = this.newChannelTF.func_146179_b().trim().length() > 0;
    }

    public IconEIO getIcon() {
        switch (this.type) {
            case FLUID: {
                return IconEIO.WRENCH_OVERLAY_FLUID;
            }
            case ITEM: {
                return IconEIO.WRENCH_OVERLAY_ITEM;
            }
            case POWER: {
                return IconEIO.WRENCH_OVERLAY_POWER;
            }
            case RAIL: {
                return IconEIO.ENDER_RAIL;
            }
        }
        return IconEIO.WRENCH_OVERLAY_POWER;
    }

    public void updateScreen() {
        this.newChannelTF.func_146178_a();
    }

    public void render(float partialTick, int mouseX, int mouseY) {
        this.newChannelTF.func_146194_f();
        this.channelList.drawScreen(mouseX, mouseY, partialTick);
        this.sendChannels.drawScreen(mouseX, mouseY, partialTick);
        this.recieveChannels.drawScreen(mouseX, mouseY, partialTick);
        int left = this.parent.getGuiLeft();
        int top = this.parent.getGuiTop();
        int x = left + 59;
        int y = top + 36;
        this.parent.func_73732_a(this.parent.getFontRenderer(), EnderIO.lang.localize("gui.available"), x, y, ColorUtil.getRGB((Color)Color.white));
        x = left + 199;
        this.parent.func_73732_a(this.parent.getFontRenderer(), EnderIO.lang.localize("gui.send"), x, y, ColorUtil.getRGB((Color)Color.white));
        this.parent.func_73732_a(this.parent.getFontRenderer(), EnderIO.lang.localize("gui.receive"), x, y += 56, ColorUtil.getRGB((Color)Color.white));
    }

    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == 3) {
            this.addChannelPressed();
        } else if (guiButton.field_146127_k == 5) {
            this.deleteChannelPressed();
        } else if (guiButton.field_146127_k == 6) {
            this.sendTogglePressed();
        } else if (guiButton.field_146127_k == 7) {
            this.receiveTogglePressed();
        }
    }

    protected void receiveTogglePressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null && !this.transceiver.getRecieveChannels(this.type).contains(c)) {
            this.transceiver.addRecieveChanel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, false, true, c));
        } else {
            c = (Channel)this.recieveChannels.getSelectedElement();
            if (c != null) {
                this.transceiver.removeRecieveChanel(c);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, false, false, c));
            }
        }
    }

    protected void sendTogglePressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null && !this.transceiver.getSendChannels(this.type).contains(c)) {
            this.transceiver.addSendChanel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, true, true, c));
        } else {
            c = (Channel)this.sendChannels.getSelectedElement();
            if (c != null) {
                this.transceiver.removeSendChanel(c);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendRecieveChannel(this.transceiver, true, false, c));
            }
        }
    }

    private void deleteChannelPressed() {
        Channel c = (Channel)this.channelList.getSelectedElement();
        if (c != null) {
            ClientChannelRegister.instance.removeChannel(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(c, false));
        }
    }

    private void addChannelPressed() {
        if (this.newChannelTF.func_146179_b() == null || this.newChannelTF.func_146179_b().trim().isEmpty()) {
            return;
        }
        Channel c = this.privateButton.isSelected() ? new Channel(this.newChannelTF.func_146179_b(), Minecraft.func_71410_x().field_71439_g.func_146103_bH(), this.type) : new Channel(this.newChannelTF.func_146179_b(), this.type);
        ClientChannelRegister.instance.addChannel(c);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddRemoveChannel(c, true));
        this.channelList.setSelection(c);
        this.newChannelTF.func_146180_a("");
    }

    public void mouseClicked(int x, int y, int par3) {
        this.newChannelTF.func_146192_a(x, y, par3);
    }
}

