/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import crazypants.enderio.config.Config;
import crazypants.util.NullHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public enum SolarType implements IStringSerializable
{
    SIMPLE(""),
    ADVANCED(".advanced"),
    VIBRANT(".vibrant");

    public static final PropertyEnum<SolarType> KIND;
    @Nonnull
    private final String unlocalisedName;

    private SolarType(String unlocalisedName) {
        this.unlocalisedName = unlocalisedName;
    }

    public boolean connectTo(@Nonnull SolarType other) {
        return this == other;
    }

    @Nonnull
    public String func_176610_l() {
        return NullHelper.notnullJ(this.name().toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
    }

    @Nonnull
    public static SolarType getTypeFromMeta(int meta) {
        return NullHelper.notnullJ(SolarType.values()[meta >= 0 && meta < SolarType.values().length ? meta : 0], "Enum.values()");
    }

    public static int getMetaFromType(@Nonnull SolarType fusedQuartzType) {
        return fusedQuartzType.ordinal();
    }

    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public int getRfperTick() {
        switch (this) {
            case ADVANCED: {
                return Config.maxPhotovoltaicAdvancedOutputRF;
            }
            case SIMPLE: {
                return Config.maxPhotovoltaicOutputRF;
            }
            case VIBRANT: {
                return Config.maxPhotovoltaicVibrantOutputRF;
            }
        }
        return 0;
    }

    static {
        KIND = PropertyEnum.func_177709_a((String)"kind", SolarType.class);
    }
}

