/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPowerMonitorConfig
extends MessageTileEntity<TilePowerMonitor> {
    private boolean engineControlEnabled;
    private float startLevel;
    private float stopLevel;

    public PacketPowerMonitorConfig() {
    }

    public PacketPowerMonitorConfig(TilePowerMonitor tile, boolean engineControlEnabled, float startLevel, float stopLevel) {
        super((TileEntity)tile);
        this.engineControlEnabled = engineControlEnabled;
        this.startLevel = startLevel;
        this.stopLevel = stopLevel;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.engineControlEnabled = buf.readBoolean();
        this.startLevel = buf.readFloat();
        this.stopLevel = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.engineControlEnabled);
        buf.writeFloat(this.startLevel);
        buf.writeFloat(this.stopLevel);
    }

    public static class ServerHandler
    implements IMessageHandler<PacketPowerMonitorConfig, IMessage> {
        public IMessage onMessage(PacketPowerMonitorConfig msg, MessageContext ctx) {
            TilePowerMonitor te = (TilePowerMonitor)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null) {
                te.setEngineControlEnabled(msg.engineControlEnabled);
                te.setStartLevel(msg.startLevel);
                te.setStopLevel(msg.stopLevel);
            }
            return null;
        }
    }
}

