/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import crazypants.enderio.machine.invpanel.ItemEntryBase;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.SlotKey;
import java.util.IdentityHashMap;
import net.minecraft.nbt.NBTTagCompound;

public class ItemEntry
extends ItemEntryBase {
    private final IdentityHashMap<SlotKey, SlotKey> slots = new IdentityHashMap();

    public ItemEntry(int dbID, int hash, int itemID, int meta, NBTTagCompound nbt) {
        super(dbID, hash, itemID, meta, nbt);
    }

    void addSlot(SlotKey slotKey) {
        this.slots.put(slotKey, slotKey);
    }

    void removeSlot(SlotKey slotKey) {
        this.slots.remove(slotKey);
    }

    public int countItems() {
        int count = 0;
        for (SlotKey slotKey : this.slots.values()) {
            count += slotKey.count;
        }
        return count;
    }

    int extractItems(InventoryDatabaseServer db, int count) {
        SlotKey[] copy;
        int extracted = 0;
        for (SlotKey slotKey : copy = this.slots.values().toArray(new SlotKey[this.slots.size()])) {
            int amount = slotKey.inv.extractItem(db, this, slotKey.slot, count);
            extracted += amount;
            if ((count -= amount) <= 0) break;
        }
        return extracted;
    }
}

