/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import crazypants.util.Prep;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public abstract class RubberTreeFarmer
extends TreeFarmer {
    protected ItemStack stickyResin;

    public RubberTreeFarmer(Block sapling, Block wood, Item treetap, ItemStack resin) {
        super(sapling, wood);
        TileFarmStation.TREETAPS.add(treetap);
        this.stickyResin = resin;
        FarmStationContainer.slotItemsProduce.add(this.stickyResin);
    }

    public boolean isValid() {
        return this.woods != null && this.woods.length > 0 && this.sapling != null && Prep.isValid(this.saplingItem) && Prep.isValid(this.stickyResin);
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block blockIn, IBlockState meta) {
        if (this.canPlant(farm.getSeedTypeInSuppliesFor(bc))) {
            if (Math.abs(farm.func_174877_v().func_177958_n() - bc.func_177958_n()) % 2 == 0) {
                return true;
            }
            if (Math.abs(farm.func_174877_v().func_177952_p() - bc.func_177952_p()) % 2 == 0) {
                return true;
            }
            World world = farm.func_145831_w();
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos pos = bc.func_177982_a(x, 0, z);
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.isLeaves(state, (IBlockAccess)world, pos) || block.isAir(state, (IBlockAccess)world, pos) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, pos)) continue;
                    return true;
                }
            }
            return super.prepareBlock(farm, bc, blockIn, meta);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos pos, Block block, IBlockState meta) {
        HarvestResult res = new HarvestResult();
        World world = farm.func_145831_w();
        int noShearingPercentage = farm.isLowOnSaplings(pos);
        int shearCount = 0;
        while (pos.func_177956_o() <= 255) {
            IBlockState state = world.func_180495_p(pos);
            if (this.isWood(state.func_177230_c())) {
                if (this.canHarvest(world, pos)) {
                    if (farm.hasTool(TileFarmStation.ToolType.TREETAP)) {
                        this.harvest(res, world, pos);
                        farm.damageTool(TileFarmStation.ToolType.TREETAP, this.woods[0], pos, 1);
                    } else {
                        farm.setNotification(FarmNotification.NO_TREETAP);
                    }
                }
                for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                    shearCount = this.harvestLeavesBlock(farm, res, world, pos.func_177972_a(face), noShearingPercentage, shearCount);
                }
            } else if (TreeHarvestUtil.isLeaves(state)) {
                shearCount = this.harvestLeavesBlock(farm, res, world, pos, noShearingPercentage, shearCount);
            } else {
                return res;
            }
            pos = pos.func_177984_a();
        }
        return res;
    }

    private int harvestLeavesBlock(TileFarmStation farm, HarvestResult res, World world, BlockPos pos, int noShearingPercentage, int shearCount) {
        IBlockState state = world.func_180495_p(pos);
        if (TreeHarvestUtil.isLeaves(state)) {
            List drops;
            if (state.func_177230_c() instanceof IShearable && farm.hasShears() && shearCount / (res.harvestedBlocks.size() + 1) + noShearingPercentage < 100) {
                drops = ((IShearable)state.func_177230_c()).onSheared(null, (IBlockAccess)farm.func_145831_w(), pos, 0);
                shearCount += 100;
                farm.damageShears(state.func_177230_c(), pos);
            } else if (farm.hasHoe()) {
                drops = state.func_177230_c().getDrops((IBlockAccess)farm.func_145831_w(), pos, state, farm.getAxeLootingValue());
                farm.damageHoe(1, pos);
            } else {
                return shearCount;
            }
            world.func_175698_g(pos);
            for (ItemStack drop : drops) {
                EntityItem dropEnt = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, drop);
                res.getDrops().add(dropEnt);
            }
            res.getHarvestedBlocks().add(pos);
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                shearCount = this.harvestLeavesBlock(farm, res, world, pos.func_177972_a(face), noShearingPercentage, shearCount);
            }
        }
        return shearCount;
    }

    private boolean canHarvest(World world, BlockPos pos) {
        return this.hasResin(world.func_180495_p(pos));
    }

    private void harvest(HarvestResult res, World world, BlockPos pos) {
        world.func_180501_a(pos, this.removeResin(world.func_180495_p(pos)), 3);
        ItemStack drop = this.makeResin(world.field_73012_v);
        EntityItem dropEnt = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, drop);
        res.getDrops().add(dropEnt);
        res.getHarvestedBlocks().add(pos);
    }

    protected ItemStack makeResin(Random rand) {
        return this.stickyResin.func_77946_l();
    }

    protected abstract boolean hasResin(IBlockState var1);

    protected abstract IBlockState removeResin(IBlockState var1);
}

