/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.loot;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Buckets;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.loot.LootSelector;
import crazypants.enderio.loot.SetRandomDarkUpgrade;
import crazypants.enderio.loot.SetRandomEnergy;
import crazypants.enderio.material.Alloy;
import crazypants.util.CapturedMob;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootManager {
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static LootManager INSTANCE = new LootManager();
    int capCount = 0;
    private static LootSelector ls = new LootSelector(NO_CONDITIONS);

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    private LootManager() {
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent evt) {
        LootTable table = evt.getTable();
        LootPool lp = new LootPool(new LootEntry[0], NO_CONDITIONS, new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 0.0f), "Ender IO");
        if (evt.getName().equals((Object)LootTableList.field_186422_d)) {
            if (Config.lootDarkSteel) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.DARK_STEEL.ordinal(), 1, 3, 0.25f));
            }
            if (Config.lootItemConduitProbe) {
                lp.addEntry(this.createLootEntry(ModObject.itemConduitProbe.getItem(), 0.1f));
            }
            if (Config.lootQuartz) {
                lp.addEntry(this.createLootEntry(Items.field_151128_bU, 3, 16, 0.25f));
            }
            if (Config.lootNetherWart) {
                lp.addEntry(this.createLootEntry(Items.field_151075_bm, 1, 4, 0.2f));
            }
            if (Config.lootEnderPearl) {
                lp.addEntry(this.createLootEntry(Items.field_151079_bi, 1, 2, 0.3f));
            }
            if (Config.lootTheEnder) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 0.1f));
            }
            if (Config.lootDarkSteelBoots) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 0.1f));
            }
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186424_f)) {
            if (Config.lootDarkSteel) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.DARK_STEEL.ordinal(), 1, 3, 0.05f));
            }
            if (Config.lootEnderPearl) {
                lp.addEntry(this.createLootEntry(Items.field_151079_bi, 1, 2, 0.1f));
            }
            if (Config.lootTheEnder) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 0.2f));
            }
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.05f));
        } else if (evt.getName().equals((Object)LootTableList.field_186425_g)) {
            if (Config.lootDarkSteelBoots) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 0.1f));
            }
            lp.addEntry(this.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186431_m)) {
            CapturedMob polarBear = CapturedMob.create("PolarBear", null);
            if (polarBear != null) {
                lp.addEntry((LootEntry)new LootEntryItem(ModObject.itemSoulVessel.getItem(), 1, 1, new LootFunction[]{this.setCount(1, 1), new SetNBT(NO_CONDITIONS, polarBear.toNbt(null))}, new LootCondition[]{new RandomChance(0.2f)}, "PolarBearSoulVial"));
            }
            lp.addEntry(this.createLootEntry(ModObject.itemSoulVessel.getItem(), 1, 3, 0.5f));
            lp.addEntry(this.createLootCapacitor(0.05f));
        } else if (evt.getName().equals((Object)LootTableList.field_189420_m)) {
            ItemStack bucket = Buckets.itemBucketFireWater.func_77946_l();
            lp.addEntry((LootEntry)new LootEntryItem(bucket.func_77973_b(), 1, 1, new LootFunction[]{this.setCount(1, 1), this.setMetadata(bucket.func_77960_j()), this.setNBT(bucket)}, new LootCondition[]{new RandomChance(0.05f)}, bucket.func_77973_b().getRegistryName().toString() + ":" + bucket.func_77960_j()));
        } else if (evt.getName().equals((Object)LootTableList.field_186423_e)) {
            if (Config.lootElectricSteel) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.ELECTRICAL_STEEL.ordinal(), 2, 6, 0.2f));
            }
            if (Config.lootRedstoneAlloy) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.REDSTONE_ALLOY.ordinal(), 3, 6, 0.35f));
            }
            if (Config.lootDarkSteel) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.DARK_STEEL.ordinal(), 3, 6, 0.35f));
            }
            if (Config.lootPhasedIron) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.PULSATING_IRON.ordinal(), 1, 2, 0.3f));
            }
            if (Config.lootPhasedGold) {
                lp.addEntry(this.createLootEntry(ModObject.itemAlloy.getItem(), Alloy.VIBRANT_ALLOY.ordinal(), 1, 2, 0.2f));
            }
            if (Config.lootTheEnder) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1, 1, 0.25f));
            }
            if (Config.lootDarkSteelBoots) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 1, 1, 0.25f));
            }
            lp.addEntry(this.createLootCapacitor(0.1f));
        } else if (evt.getName().equals((Object)LootTableList.field_186429_k)) {
            if (Config.lootTheEnder) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 0.2f));
            }
            if (Config.lootTravelStaff) {
                lp.addEntry(this.createLootEntry(ModObject.itemTravelStaff.getItem(), 0.1f));
            }
            lp.addEntry(this.createLootCapacitor(25.0f));
        } else if (evt.getName().equals((Object)LootTableList.field_186430_l)) {
            if (Config.lootTheEnder) {
                lp.addEntry(this.createDarkSteelLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1, 1, 0.25f));
            }
            if (Config.lootTravelStaff) {
                lp.addEntry(this.createLootEntry(ModObject.itemTravelStaff.getItem(), 1, 1, 0.1f));
            }
            lp.addEntry(this.createLootCapacitor(0.25f));
            lp.addEntry(this.createLootCapacitor(0.25f));
        }
        table.addPool(lp);
    }

    private LootEntry createLootEntry(Item item, float chance) {
        return this.createLootEntry(item, 1, 1, chance);
    }

    private LootEntry createLootEntry(Item item, int minSize, int maxSize, float chance) {
        return this.createLootEntry(item, 0, minSize, maxSize, chance);
    }

    private LootEntry createLootEntry(Item item, int ordinal, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        if (item.func_77645_m()) {
            return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setDamage(item, ordinal), this.setEnergy()}, chanceCond, item.getRegistryName().toString() + ":" + ordinal);
        }
        return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setMetadata(ordinal)}, chanceCond, item.getRegistryName().toString() + ":" + ordinal);
    }

    private LootEntry createDarkSteelLootEntry(Item item, float chance) {
        return this.createDarkSteelLootEntry(item, 1, 1, chance);
    }

    private LootEntry createDarkSteelLootEntry(Item item, int minSize, int maxSize, float chance) {
        return this.createDarkSteelLootEntry(item, 0, minSize, maxSize, chance);
    }

    private LootEntry createDarkSteelLootEntry(Item item, int ordinal, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setDamage(item, ordinal), this.setUpgrades(), this.setEnergy()}, chanceCond, item.getRegistryName().toString() + ":" + ordinal);
    }

    private LootEntry createLootCapacitor(float chance) {
        ++this.capCount;
        return new LootEntryItem(ModObject.itemBasicCapacitor.getItem(), 1, 1, new LootFunction[]{ls, this.setMetadata(3)}, new LootCondition[]{new RandomChance(chance)}, ModObject.itemBasicCapacitor.getItem().getRegistryName().toString() + this.capCount);
    }

    private SetCount setCount(int min, int max) {
        return new SetCount(NO_CONDITIONS, new RandomValueRange((float)min, (float)min));
    }

    private SetDamage setDamage(Item item, int damage) {
        return new SetDamage(NO_CONDITIONS, new RandomValueRange(damage > 0 ? (float)damage : 1.0f, damage > 0 ? (float)damage : (float)item.func_77612_l()));
    }

    private SetMetadata setMetadata(int meta) {
        return new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)meta));
    }

    private SetRandomEnergy setEnergy() {
        return new SetRandomEnergy(NO_CONDITIONS);
    }

    private SetRandomDarkUpgrade setUpgrades() {
        return new SetRandomDarkUpgrade(NO_CONDITIONS);
    }

    private SetNBT setNBT(ItemStack stack) {
        return new SetNBT(NO_CONDITIONS, stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound());
    }
}

