/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.material.Material;
import crazypants.enderio.power.PowerDisplayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyUpgrade
extends AbstractUpgrade {
    public static final AbstractUpgrade EMPOWERED = new EnergyUpgrade(0, "enderio.darksteel.upgrade.empowered_one", Config.darkSteelUpgradeVibrantCost, new ItemStack(ModObject.itemMaterial.getItem(), 1, Material.VIBRANT_CYSTAL.ordinal()), Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase / 100);
    public static final AbstractUpgrade EMPOWERED_TWO = new EnergyUpgrade(1, "enderio.darksteel.upgrade.empowered_two", Config.darkSteelUpgradePowerOneCost, new ItemStack(ModObject.itemBasicCapacitor.getItem(), 1, 0), Config.darkSteelPowerStorageLevelOne, Config.darkSteelPowerStorageLevelOne / 100);
    public static final AbstractUpgrade EMPOWERED_THREE = new EnergyUpgrade(2, "enderio.darksteel.upgrade.empowered_three", Config.darkSteelUpgradePowerTwoCost, new ItemStack(ModObject.itemBasicCapacitor.getItem(), 1, 1), Config.darkSteelPowerStorageLevelTwo, Config.darkSteelPowerStorageLevelTwo / 100);
    public static final AbstractUpgrade EMPOWERED_FOUR = new EnergyUpgrade(3, "enderio.darksteel.upgrade.empowered_four", Config.darkSteelUpgradePowerThreeCost, new ItemStack(ModObject.itemBasicCapacitor.getItem(), 1, 2), Config.darkSteelPowerStorageLevelThree, Config.darkSteelPowerStorageLevelThree / 100);
    private static final String UPGRADE_NAME = "energyUpgrade";
    private static final String KEY_CAPACITY = "capacity";
    private static final String KEY_ENERGY = "energy";
    private static final String KEY_MAX_IN = "maxInput";
    private static final String KEY_MAX_OUT = "maxOuput";
    private static final Random RANDOM = new Random();
    private static final String KEY_LEVEL = "energyUpgradeLevel";
    protected final int capacity;
    protected final int level;
    protected int energy;
    protected final int maxInRF;
    protected final int maxOutRF;

    public static EnergyUpgrade loadFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.func_74764_b("enderio.darksteel.upgrade.energyUpgrade")) {
            return null;
        }
        return new EnergyUpgrade(nbt.func_74775_l("enderio.darksteel.upgrade.energyUpgrade"));
    }

    public static EnergyUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return EnergyUpgrade.loadFromNBT(stack.func_77978_p());
    }

    public static boolean itemHasAnyPowerUpgrade(ItemStack itemstack) {
        return EnergyUpgrade.loadFromItem(itemstack) != null;
    }

    public static AbstractUpgrade next(AbstractUpgrade upgrade) {
        if (upgrade == null) {
            return EMPOWERED;
        }
        if (upgrade.unlocName.equals(EnergyUpgrade.EMPOWERED.unlocName)) {
            return EMPOWERED_TWO;
        }
        if (upgrade.unlocName.equals(EnergyUpgrade.EMPOWERED_TWO.unlocName)) {
            return EMPOWERED_THREE;
        }
        if (upgrade.unlocName.equals(EnergyUpgrade.EMPOWERED_THREE.unlocName)) {
            return EMPOWERED_FOUR;
        }
        return null;
    }

    public static int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        int res = eu.extractEnergy(maxExtract, simulate);
        if (!simulate && res > 0) {
            eu.writeToItem(container);
        }
        return res;
    }

    public static int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        int res = eu.receiveEnergy(maxReceive, simulate);
        if (!simulate && res > 0) {
            eu.writeToItem(container);
        }
        return res;
    }

    public static void setPowerLevel(ItemStack item, int amount) {
        if (item == null || !EnergyUpgrade.itemHasAnyPowerUpgrade(item)) {
            return;
        }
        amount = Math.min(amount, EnergyUpgrade.getMaxEnergyStored(item));
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(item);
        eu.setEnergy(amount);
        eu.writeToItem(item);
    }

    public static void setPowerFull(ItemStack item) {
        if (item == null || !EnergyUpgrade.itemHasAnyPowerUpgrade(item)) {
            return;
        }
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(item);
        eu.setEnergy(eu.getCapacity());
        eu.writeToItem(item);
    }

    public static String getStoredEnergyString(ItemStack itemstack) {
        EnergyUpgrade up = EnergyUpgrade.loadFromItem(itemstack);
        if (up == null) {
            return null;
        }
        return PowerDisplayUtil.formatStoredPower(up.energy, up.capacity);
    }

    public static int getEnergyStored(ItemStack container) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        return eu.getEnergy();
    }

    public static int getMaxEnergyStored(ItemStack container) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        return eu.getCapacity();
    }

    public EnergyUpgrade(int level, String name, int levels, ItemStack upgradeItem, int capacity, int maxReceiveIO) {
        super(UPGRADE_NAME, name, upgradeItem, levels);
        this.level = level;
        this.capacity = capacity;
        this.energy = 0;
        this.maxInRF = maxReceiveIO;
        this.maxOutRF = maxReceiveIO;
    }

    public EnergyUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.func_74762_e(KEY_LEVEL);
        this.capacity = tag.func_74762_e(KEY_CAPACITY);
        this.energy = tag.func_74762_e(KEY_ENERGY);
        this.maxInRF = tag.func_74762_e(KEY_MAX_IN);
        this.maxOutRF = tag.func_74762_e(KEY_MAX_OUT);
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        EnergyUpgrade up = EnergyUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IDarkSteelItem)) {
            return false;
        }
        AbstractUpgrade up = EnergyUpgrade.next(EnergyUpgrade.loadFromItem(stack));
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ArrayList<String> upgradeStr = new ArrayList<String>();
        upgradeStr.add(TextFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
        SpecialTooltipHandler.addDetailedTooltipFromResources(upgradeStr, (String)this.getUnlocalizedName());
        String percDamage = (int)Math.round(this.getAbsorptionRatio() * 100.0) + "";
        String capString = PowerDisplayUtil.formatPower(this.capacity) + " " + PowerDisplayUtil.abrevation();
        for (int i = 0; i < upgradeStr.size(); ++i) {
            String str = (String)upgradeStr.get(i);
            str = str.replaceAll("\\$P", capString);
            str = str.replaceAll("\\$D", percDamage);
            upgradeStr.set(i, str);
        }
        list.addAll(upgradeStr);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74768_a(KEY_LEVEL, this.level);
        upgradeRoot.func_74768_a(KEY_CAPACITY, this.capacity);
        upgradeRoot.func_74768_a(KEY_ENERGY, this.energy);
        upgradeRoot.func_74768_a(KEY_MAX_IN, this.maxInRF);
        upgradeRoot.func_74768_a(KEY_MAX_OUT, this.maxOutRF);
    }

    public boolean isAbsorbDamageWithPower() {
        boolean res = RANDOM.nextDouble() < this.getAbsorptionRatio();
        return res;
    }

    private double getAbsorptionRatio() {
        int val = this.level;
        if (val >= Config.darkSteelPowerDamgeAbsorptionRatios.length) {
            val = 0;
        }
        return Config.darkSteelPowerDamgeAbsorptionRatios[val];
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if (energy < 0) {
            energy = 0;
        }
        this.energy = energy;
    }

    public int getLevel() {
        return this.level;
    }

    public int receiveEnergy(int maxRF, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxInRF, maxRF));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxOutRF, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

