/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.Config;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeConfigElement;
import crazypants.enderio.config.recipes.StaxFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Level
implements RecipeConfigElement {
    private Integer minlevel;
    private Integer maxlevel;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.minlevel == null) {
            this.minlevel = 0;
        } else if (this.minlevel < 0) {
            throw new InvalidRecipeConfigException("Invalid negative 'minlevel' in <level>");
        }
        if (this.maxlevel == null) {
            this.maxlevel = Integer.MAX_VALUE;
        } else if (this.maxlevel < 0) {
            throw new InvalidRecipeConfigException("Invalid negative 'maxlevel' in <level>");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return Config.recipeLevel >= this.minlevel && Config.recipeLevel <= this.maxlevel;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("minlevel".equals(name)) {
            this.minlevel = Integer.valueOf(value);
            return true;
        }
        if ("maxlevel".equals(name)) {
            this.maxlevel = Integer.valueOf(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }
}

