/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeRoot;
import crazypants.enderio.config.recipes.StaxFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;

public class RecipeFactory {
    private static final String DEFAULT_USER_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<enderio:recipes xmlns:enderio=\"http://enderio.com/recipes\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://enderio.com/recipes recipes.xsd \">\n\n</enderio:recipes>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RecipeRoot> T readFile(T target, String rootElement, String fileName) throws IOException, XMLStreamException {
        File configFile;
        RecipeRoot defaultConfig;
        InputStream defaultFileStream;
        FileInputStream userFileStream;
        block13: {
            RecipeRoot e3;
            RecipeFactory.copyCore("recipes.xsd");
            userFileStream = null;
            defaultFileStream = null;
            try {
                RecipeRoot userConfig = null;
                defaultConfig = null;
                RecipeFactory.copyCore(fileName + "_core.xml");
                String coreFile = "/assets/" + EnderIO.DOMAIN + "/config/" + fileName + "_core.xml";
                defaultFileStream = RecipeFactory.class.getResourceAsStream(coreFile);
                if (defaultFileStream == null) {
                    throw new IOException("Could not get resource " + coreFile + " from classpath. ");
                }
                try {
                    defaultConfig = RecipeFactory.readStax(target.copy(target), rootElement, defaultFileStream);
                }
                catch (XMLStreamException e2) {
                    RecipeFactory.printContentsOnError(RecipeFactory.class.getResourceAsStream(coreFile), coreFile);
                    throw e2;
                }
                configFile = new File(Config.configDirectory, fileName + "_user.xml");
                if (!configFile.exists()) break block13;
                userFileStream = new FileInputStream(configFile);
                try {
                    userConfig = RecipeFactory.readStax(target, rootElement, userFileStream);
                }
                catch (XMLStreamException e3) {
                    RecipeFactory.printContentsOnError(new FileInputStream(configFile), configFile.toString());
                    throw e3;
                }
                userConfig.addRecipes(defaultConfig);
                e3 = userConfig;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(userFileStream);
                IOUtils.closeQuietly(defaultFileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)userFileStream);
            IOUtils.closeQuietly((InputStream)defaultFileStream);
            return (T)e3;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(configFile, false));
            writer.write(DEFAULT_USER_FILE);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
        RecipeRoot recipeRoot = defaultConfig;
        IOUtils.closeQuietly((InputStream)userFileStream);
        IOUtils.closeQuietly((InputStream)defaultFileStream);
        return (T)recipeRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void printContentsOnError(InputStream stream, String filename) throws FileNotFoundException, IOException {
        Log.error("Failed to parse xml from file '", filename, "'. Content:");
        try {
            int data = 0;
            while (data != -1) {
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    data = stream.read();
                    if (data != -1) {
                        sb1.append(String.format("%02x ", data));
                        if (data > 32 && data < 128) {
                            sb2.appendCodePoint(data);
                            continue;
                        }
                        sb2.append(".");
                        continue;
                    }
                    sb1.append("   ");
                }
                Log.error(sb1, sb2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static <T extends RecipeRoot> T readStax(T target, String rootElement, InputStream in) throws XMLStreamException, InvalidRecipeConfigException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        StaxFactory factory = new StaxFactory(eventReader);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            if (rootElement.equals(startElement.getName().getLocalPart())) {
                return factory.read(target, startElement);
            }
            throw new InvalidRecipeConfigException("Unexpected tag '" + startElement.getName() + "'");
        }
        throw new InvalidRecipeConfigException("Missing recipes tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyCore(String filename) {
        FileOutputStream schemaOut;
        InputStream schemaIn;
        block4: {
            schemaIn = null;
            schemaOut = null;
            try {
                File file = new File(Config.configDirectory, filename);
                schemaIn = RecipeFactory.class.getResourceAsStream("/assets/" + EnderIO.DOMAIN + "/config/" + filename);
                if (schemaIn == null) break block4;
                schemaOut = new FileOutputStream(file);
                IOUtils.copy((InputStream)schemaIn, (OutputStream)schemaOut);
            }
            catch (IOException e) {
                try {
                    Log.error("Copying default recipe file " + filename + " failed. Reason:");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(schemaIn);
                    IOUtils.closeQuietly(schemaOut);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)schemaIn);
                IOUtils.closeQuietly(schemaOut);
            }
        }
        IOUtils.closeQuietly((InputStream)schemaIn);
        IOUtils.closeQuietly(schemaOut);
    }
}

