/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.me;

import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.MESettings;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.me.MEConduitGrid;
import crazypants.enderio.conduit.me.MEConduitNetwork;
import crazypants.enderio.render.registry.TextureRegistry;
import crazypants.enderio.tool.ToolUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MEConduit
extends AbstractConduit
implements IMEConduit {
    protected MEConduitNetwork network;
    protected MEConduitGrid grid;
    public static TextureRegistry.TextureSupplier coreTextureN = TextureRegistry.registerTexture("blocks/meConduitCore");
    public static TextureRegistry.TextureSupplier coreTextureD = TextureRegistry.registerTexture("blocks/meConduitCoreDense");
    public static TextureRegistry.TextureSupplier longTextureN = TextureRegistry.registerTexture("blocks/meConduit");
    public static TextureRegistry.TextureSupplier longTextureD = TextureRegistry.registerTexture("blocks/meConduitDense");
    private boolean isDense;
    private int playerID = -1;

    public MEConduit() {
        this(0);
    }

    public MEConduit(int itemDamage) {
        this.isDense = itemDamage == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
    }

    public static int getDamageForState(boolean isDense) {
        return isDense ? 1 : 0;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IMEConduit.class;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack(ModObject.itemMEConduit.getItem(), 1, MEConduit.getDamageForState(this.isDense));
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (MEConduitNetwork)network;
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74757_a("isDense", this.isDense);
        nbtRoot.func_74768_a("playerID", this.playerID);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.isDense = nbtRoot.func_74767_n("isDense");
        this.playerID = nbtRoot.func_74764_b("playerID") ? nbtRoot.func_74762_e("playerID") : -1;
    }

    public void setPlayerID(int playerID) {
        this.playerID = playerID;
    }

    @Override
    public int getChannelsInUse() {
        int channelsInUse = 0;
        IGridNode node = this.getNode();
        if (node != null) {
            for (IGridConnection gc : node.getConnections()) {
                channelsInUse = Math.max(channelsInUse, gc.getUsedChannels());
            }
        }
        return channelsInUse;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public boolean canConnectToExternal(EnumFacing dir, boolean ignoreDisabled) {
        BlockCoord pos;
        World world = this.getBundle().getBundleWorldObj();
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)(pos = this.getLocation()).getLocation(dir).getBlockPos());
        if (te instanceof TileConduitBundle) {
            return false;
        }
        if (te instanceof IPartHost) {
            IPart part = ((IPartHost)te).getPart(dir.func_176734_d());
            if (part == null) {
                part = ((IPartHost)te).getPart(AEPartLocation.INTERNAL);
                return part != null;
            }
            if (part.getExternalFacingNode() != null) {
                return true;
            }
            String name = part.getClass().getSimpleName();
            return "PartP2PTunnelME".equals(name) || "PartQuartzFiber".equals(name) || "PartToggleBus".equals(name) || "PartInvertedToggleBus".equals(name);
        }
        if (te instanceof IGridHost) {
            IGridNode node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir.func_176734_d()));
            if (node == null) {
                node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL);
            }
            if (node != null) {
                return node.getGridBlock().getConnectableSides().contains(dir.func_176734_d());
            }
        }
        return false;
    }

    @Override
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return (this.isDense ? coreTextureD : coreTextureN).get(TextureAtlasSprite.class);
        }
        return (this.isDense ? longTextureD : longTextureN).get(TextureAtlasSprite.class);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        return null;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void updateEntity(World worldObj) {
        IGridNode node;
        if (this.grid == null) {
            this.grid = new MEConduitGrid(this);
        }
        if (this.getNode() == null && !worldObj.field_72995_K && (node = AEApi.instance().createGridNode((IGridBlock)this.grid)) != null) {
            node.setPlayerID(this.playerID);
            this.getBundle().setGridNode(node);
            this.getNode().updateState();
        }
        super.updateEntity(worldObj);
    }

    @Override
    public ConnectionMode getNextConnectionMode(EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(EnumFacing dir) {
        return this.getNextConnectionMode(dir);
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit conduit) {
        if (!super.canConnectToConduit(direction, conduit)) {
            return false;
        }
        return conduit instanceof IMEConduit;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void connectionsChanged() {
        super.connectionsChanged();
        BlockCoord loc = this.getLocation();
        if (loc != null) {
            this.onNodeChanged(loc);
            IGridNode node = this.getNode();
            if (node != null) {
                node.updateState();
                World world = node.getWorld();
                if (!world.field_72995_K && world instanceof WorldServer) {
                    ((WorldServer)world).func_184164_w().func_180244_a(loc.getBlockPos());
                }
            }
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        if (ToolUtil.isToolEquipped(player, hand) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
            EnumFacing connDir = res.component.dir;
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (connDir == null || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                return ConduitUtil.joinConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    private void onNodeChanged(BlockCoord location) {
        World world = this.getBundle().getBundleWorldObj();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = location.getLocation(dir).getTileEntity((IBlockAccess)world);
            if (te == null || !(te instanceof IGridHost) || te instanceof IConduitBundle) continue;
            IGridNode node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL);
            if (node == null) {
                node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir.func_176734_d()));
            }
            if (node == null) continue;
            node.updateState();
        }
    }

    @Override
    public void onAddedToBundle() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IMEConduit cond;
            TileEntity te = this.getLocation().getLocation(dir).getTileEntity((IBlockAccess)this.getBundle().getBundleWorldObj());
            if (!(te instanceof TileConduitBundle) || (cond = ((TileConduitBundle)te).getConduit(IMEConduit.class)) == null) continue;
            cond.setConnectionMode(dir.func_176734_d(), ConnectionMode.IN_OUT);
            ConduitUtil.joinConduits(cond, dir.func_176734_d());
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void onRemovedFromBundle() {
        super.onRemovedFromBundle();
        this.getNode().destroy();
        this.getBundle().setGridNode(null);
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void onChunkUnload(World worldObj) {
        super.onChunkUnload(worldObj);
        if (this.getNode() != null) {
            this.getNode().destroy();
            this.getBundle().setGridNode(null);
        }
    }

    @Override
    public MEConduitGrid getGrid() {
        return this.grid;
    }

    @Optional.Method(modid="appliedenergistics2")
    private IGridNode getNode() {
        return this.getBundle().getGridNode(null);
    }

    @Override
    public EnumSet<EnumFacing> getConnections() {
        EnumSet<EnumFacing> cons = EnumSet.noneOf(EnumFacing.class);
        cons.addAll(this.getConduitConnections());
        for (EnumFacing dir : this.getExternalConnections()) {
            if (this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            cons.add(dir);
        }
        return cons;
    }

    @Override
    public boolean isDense() {
        return this.isDense;
    }

    public MEConduitNetwork createNetworkForType() {
        return new MEConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITabPanel createPanelForConduit(GuiExternalConnection gui, IConduit con) {
        return new MESettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTabOrderForConduit(IConduit con) {
        return 4;
    }
}

