/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitSignalColor;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RedstoneSettings
extends BaseSettingsPanel {
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_STRONG_BUTTON = GuiExternalConnection.nextButtonId();
    private ColorButton cb;
    private CheckBox strongCB;
    private String signalColorStr = EnderIO.lang.localize("gui.conduit.redstone.color");
    private String signalStringthStr = EnderIO.lang.localize("gui.conduit.redstone.signalStrengh");
    private IRedstoneConduit insCon;
    private int stongLabelX;

    public RedstoneSettings(GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_REDSTONE, EnderIO.lang.localize("itemRedstoneConduitInsulated.name"), gui, con);
        int x = 0;
        int y = this.customTop;
        if (con instanceof IRedstoneConduit) {
            this.insCon = (IRedstoneConduit)con;
        }
        if (this.insCon != null) {
            if (!this.insCon.isSpecialConnection(gui.getDir())) {
                this.cb = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x += this.gap + this.gap + 2 + gui.getFontRenderer().func_78256_a(this.signalColorStr), y);
                this.cb.setToolTipHeading(EnderIO.lang.localize("gui.conduit.redstone.signalColor"));
                DyeColor sigCol = this.insCon.getSignalColor(gui.getDir());
                this.cb.setColorIndex(sigCol.ordinal());
                x += this.cb.func_146117_b();
            }
            this.stongLabelX = x;
            this.strongCB = new CheckBox((IGuiScreen)gui, ID_STRONG_BUTTON, x += this.gap + gui.getFontRenderer().func_78256_a(this.signalStringthStr) + this.gap + 3, y);
            this.strongCB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.redstone.signalStrengh.tooltip")});
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON && this.cb != null) {
            this.insCon.setSignalColor(this.gui.getDir(), DyeColor.values()[this.cb.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneConduitSignalColor(this.insCon, this.gui.getDir()));
        } else if (guiButton.field_146127_k == ID_STRONG_BUTTON && this.strongCB != null) {
            this.insCon.setOutputStrength(this.gui.getDir(), this.strongCB.isSelected());
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneConduitOutputStrength(this.insCon, this.gui.getDir()));
        }
    }

    @Override
    protected void initCustomOptions() {
        if (this.insCon != null) {
            if (this.cb != null) {
                this.cb.setColorIndex(this.cb.getColorIndex());
                this.cb.onGuiInit();
            }
            this.strongCB.onGuiInit();
            this.strongCB.setSelected(this.insCon.isOutputStrong(this.gui.getDir()));
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.cb != null) {
            this.cb.detach();
        }
        if (this.strongCB != null) {
            this.strongCB.detach();
        }
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        if (this.insCon != null) {
            if (this.cb != null) {
                this.gui.getFontRenderer().func_78276_b(this.signalColorStr, this.left, top, ColorUtil.getRGB((Color)Color.darkGray));
            }
            if (this.strongCB != null) {
                this.gui.getFontRenderer().func_78276_b(this.signalStringthStr, this.left + this.stongLabelX, top, ColorUtil.getRGB((Color)Color.darkGray));
            }
        }
    }
}

