/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.IModObject;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.util.ClientUtil;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem,
IHaveRenderers {
    protected IModObject modObj;
    protected ItemConduitSubtype[] subtypes;

    protected AbstractItemConduit(IModObject modObj, ItemConduitSubtype ... subtypes) {
        this.modObj = modObj;
        this.subtypes = subtypes;
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(modObj.getUnlocalisedName());
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.setRegistryName(modObj.getUnlocalisedName());
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        for (int i = 0; i < this.subtypes.length; ++i) {
            ClientUtil.regRenderer((Item)this, i, new ResourceLocation(this.subtypes[i].modelLocation));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockCoord placeAt = Util.canPlaceItem((ItemStack)stack, (IBlockState)ModObject.blockConduitBundle.getBlock().func_176223_P(), (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.field_72995_K && world.func_180501_a(placeAt.getBlockPos(), ModObject.blockConduitBundle.getBlock().func_176223_P(), 1) && (te = world.func_175625_s(placeAt.getBlockPos())) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(stack, player));
                ConduitUtil.playBreakSound(SoundType.field_185852_e, world, placeAt.x, placeAt.y, placeAt.z);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos place = pos.func_177972_a(side);
        if (world.func_180495_p(place).func_177230_c() == ModObject.blockConduitBundle.getBlock()) {
            IConduitBundle bundle = (IConduitBundle)world.func_175625_s(place);
            if (bundle == null) {
                return EnumActionResult.PASS;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.field_72995_K) {
                    IConduit con = this.createConduit(stack, player);
                    if (con == null) {
                        return EnumActionResult.PASS;
                    }
                    bundle.addConduit(con);
                    ConduitUtil.playBreakSound(SoundType.field_185852_e, world, place.func_177958_n(), place.func_177956_o(), place.func_177952_p());
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof IConduitBundle)) {
            return EnumActionResult.PASS;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        Object existingConduit = bundle.getConduit(this.getBaseConduitType());
        if (existingConduit == null) {
            return EnumActionResult.PASS;
        }
        ItemStack existingConduitAsItemStack = existingConduit.createItem();
        if (!ItemUtil.areStacksEqual((ItemStack)existingConduitAsItemStack, (ItemStack)stack)) {
            if (!world.field_72995_K) {
                IConduit newConduit = this.createConduit(stack, player);
                if (newConduit == null) {
                    return EnumActionResult.PASS;
                }
                bundle.removeConduit((IConduit)existingConduit);
                bundle.addConduit(newConduit);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    for (ItemStack drop : existingConduit.getDrops()) {
                        if (player.field_71071_by.func_70441_a(drop)) continue;
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (BlockPos)pos, (float)hitX, (float)hitY, (float)hitZ, (float)1.1f);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                return EnumActionResult.FAIL;
            }
            player.func_184609_a(hand);
        }
        return EnumActionResult.PASS;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77952_i(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.subtypes.length; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }
}

