/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import com.enderio.core.common.util.ItemUtil;
import com.google.common.base.Predicate;
import crazypants.enderio.capability.Callback;
import crazypants.enderio.capability.Filters;
import crazypants.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class InventorySlot
implements IItemHandler {
    private ItemStack itemStack = Prep.getEmpty();
    @Nonnull
    private final Predicate<ItemStack> filterIn;
    @Nonnull
    private final Predicate<ItemStack> filterOut;
    @Nonnull
    private final Callback<ItemStack> callback;
    private final int limit;
    @Nullable
    private TileEntity owner;

    public InventorySlot() {
        this(null, null, null, null, -1);
    }

    public InventorySlot(Callback<ItemStack> callback) {
        this(null, null, null, callback, -1);
    }

    public InventorySlot(ItemStack itemStack) {
        this(itemStack, null, null, null, -1);
    }

    public InventorySlot(ItemStack itemStack, Callback<ItemStack> callback) {
        this(itemStack, null, null, callback, -1);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut) {
        this(null, filterIn, filterOut, null, -1);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback) {
        this(null, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(int limit) {
        this(null, null, null, null, limit);
    }

    public InventorySlot(Callback<ItemStack> callback, int limit) {
        this(null, null, null, callback, limit);
    }

    public InventorySlot(ItemStack itemStack, int limit) {
        this(itemStack, null, null, null, limit);
    }

    public InventorySlot(ItemStack itemStack, Callback<ItemStack> callback, int limit) {
        this(itemStack, null, null, callback, limit);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, int limit) {
        this(null, filterIn, filterOut, null, limit);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback, int limit) {
        this(null, filterIn, filterOut, callback, limit);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut) {
        this(itemStack, filterIn, filterOut, null, -1);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback) {
        this(itemStack, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, int limit) {
        this(itemStack, filterIn, filterOut, null, limit);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback, int limit) {
        this.itemStack = itemStack;
        this.filterIn = filterIn != null ? filterIn : Filters.ALWAYS_TRUE;
        this.filterOut = filterOut != null ? filterOut : Filters.ALWAYS_TRUE;
        this.callback = callback != null ? callback : Filters.NO_CALLBACK;
        this.limit = limit > 0 ? limit : 64;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.itemStack : Prep.getEmpty();
    }

    public boolean isItemValidForSlot(ItemStack stack) {
        return Prep.isValid(stack) && this.filterIn.apply((Object)stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (Prep.isInvalid(stack)) {
            return Prep.getEmpty();
        }
        if (slot == 0 && this.filterIn.apply((Object)stack)) {
            if (Prep.isInvalid(this.itemStack)) {
                int max = Math.min(this.limit, stack.func_77976_d());
                if (!simulate) {
                    this.itemStack = stack.func_77946_l();
                }
                if (stack.field_77994_a <= max) {
                    if (!simulate) {
                        this.onChange(Prep.getEmpty(), this.itemStack);
                    }
                    return Prep.getEmpty();
                }
                if (!simulate) {
                    this.itemStack.field_77994_a = max;
                    this.onChange(Prep.getEmpty(), this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.field_77994_a -= max;
                return result;
            }
            if (ItemUtil.areStackMergable((ItemStack)this.itemStack, (ItemStack)stack)) {
                int target = this.itemStack.field_77994_a + stack.field_77994_a;
                int max = Math.min(this.limit, stack.func_77976_d());
                if (target <= max) {
                    if (!simulate) {
                        ItemStack oldStack = this.itemStack.func_77946_l();
                        this.itemStack.field_77994_a = target;
                        this.onChange(oldStack, this.itemStack);
                    }
                    return Prep.getEmpty();
                }
                int tomove = max - this.itemStack.field_77994_a;
                if (!simulate) {
                    ItemStack oldStack = this.itemStack.func_77946_l();
                    this.itemStack.field_77994_a = max;
                    this.onChange(oldStack, this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.field_77994_a -= tomove;
                return result;
            }
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && Prep.isValid(this.itemStack) && this.filterOut.apply((Object)this.itemStack)) {
            if (amount >= this.itemStack.field_77994_a) {
                if (!simulate) {
                    ItemStack oldStack = this.itemStack;
                    this.itemStack = Prep.getEmpty();
                    this.onChange(oldStack, this.itemStack);
                    return oldStack;
                }
                return this.itemStack.func_77946_l();
            }
            if (!simulate) {
                ItemStack oldStack = this.itemStack.func_77946_l();
                this.itemStack.field_77994_a -= amount;
                this.onChange(oldStack, this.itemStack);
                oldStack.field_77994_a = amount;
                return oldStack;
            }
            ItemStack result = this.itemStack.func_77946_l();
            result.field_77994_a = amount;
            return result;
        }
        return Prep.getEmpty();
    }

    private void onChange(ItemStack oldStack, ItemStack newStack) {
        this.callback.onChange(oldStack, newStack);
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (Prep.isValid(this.itemStack)) {
            this.itemStack.func_77955_b(tag);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
    }

    public void clear() {
        this.itemStack = Prep.getEmpty();
    }

    public void set(ItemStack stack) {
        this.itemStack = stack;
    }

    public int getMaxStackSize() {
        return this.limit;
    }

    void setOwner(TileEntity owner) {
        this.owner = owner;
    }

    TileEntity getOwner() {
        return this.owner;
    }
}

