/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.block;

import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.util.ClientUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSelfResettingLever
extends BlockLever
implements IHaveRenderers {
    private static List<Integer> delays = new ArrayList<Integer>();
    private static List<BlockSelfResettingLever> blocks = new ArrayList<BlockSelfResettingLever>();
    private final int delay;
    private final String name;

    public String getName() {
        return this.name;
    }

    public BlockSelfResettingLever(String name, int delay) {
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.name = name;
        this.delay = delay;
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public static Block create() {
        BlockSelfResettingLever.getLevers();
        blocks.clear();
        for (Integer value : delays) {
            String name = ModObject.blockSelfResettingLever.getUnlocalisedName() + value;
            BlockSelfResettingLever lever = new BlockSelfResettingLever(name, value * 20);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)GameRegistry.register((IForgeRegistryEntry)lever)).setRegistryName(name));
            blocks.add(lever);
        }
        return blocks.isEmpty() ? null : blocks.get(0);
    }

    public static List<Integer> getLevers() {
        if (delays == null || delays.isEmpty()) {
            String[] split;
            delays.clear();
            String s = Config.leversEnabled;
            s = s.replaceAll("[^0-9,]", "");
            for (String string : split = s.split(",")) {
                if (string == null || string.isEmpty()) continue;
                try {
                    Integer value = Integer.valueOf(string);
                    if (value <= 0 || value > 86400) continue;
                    delays.add(value);
                }
                catch (NumberFormatException e) {
                    Log.error("Could not parse lever time setting '" + string + "'");
                }
            }
        }
        return delays;
    }

    public static List<BlockSelfResettingLever> getBlocks() {
        return blocks;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176359_b)).booleanValue()) {
            world.func_180497_b(pos, (Block)this, this.delay, 0);
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176359_b)).booleanValue()) {
            super.func_180639_a(world, pos, state, null, EnumHand.MAIN_HAND, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        for (BlockSelfResettingLever b : blocks) {
            ClientUtil.registerRenderer(Item.func_150898_a((Block)b), b.getName());
        }
    }
}

