/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.block;

import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.block.ItemBlockDecoration;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.enderio.render.property.EnumDecoBlock;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecoration
extends Block
implements IHaveRenderers {
    @Nonnull
    protected final String name;

    public static BlockDecoration create() {
        BlockDecoration blockDecoration = new BlockDecoration(ModObject.blockDecoration1.getUnlocalisedName());
        blockDecoration.init();
        return blockDecoration;
    }

    protected BlockDecoration(@Nonnull String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumDecoBlock.TYPE});
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockDecoration(this, this.getName()){

            public String func_77667_c(ItemStack stack) {
                return EnumDecoBlock.getTypeFromMeta(stack.func_77960_j()).getUnlocalizedName((Item)this);
            }
        });
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            for (EnumDecoBlock type : EnumDecoBlock.values()) {
                list.add(new ItemStack(itemIn, 1, EnumDecoBlock.getMetaFromType(type)));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumDecoBlock.TYPE, (Comparable)((Object)EnumDecoBlock.getTypeFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return EnumDecoBlock.getMetaFromType((EnumDecoBlock)((Object)state.func_177229_b(EnumDecoBlock.TYPE)));
    }

    public int func_180651_a(IBlockState st) {
        return this.func_176201_c(st);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        Map locations = new DefaultStateMapper().func_178130_a((Block)this);
        for (EnumDecoBlock type : EnumDecoBlock.TYPE.func_177700_c()) {
            IBlockState state = this.func_176223_P().func_177226_a(EnumDecoBlock.TYPE, (Comparable)((Object)type));
            ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumDecoBlock.getMetaFromType(type), (ModelResourceLocation)mrl);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        EnumDecoBlock type = (EnumDecoBlock)((Object)state.func_177229_b(EnumDecoBlock.TYPE));
        return type != EnumDecoBlock.TYPE00 && type != EnumDecoBlock.TYPE14 && type != EnumDecoBlock.TYPE15;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_149662_c(base_state);
    }
}

