/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.dragonmounts;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class PluginStageInfo
extends InfoProvider {
    private boolean showStage = true;
    private boolean showAdultTimer = true;
    private boolean showStageTimer = true;
    private final int maxTime = 72000;

    @Override
    @Optional.Method(modid="DragonMounts")
    public void syncConfig(Configuration config) {
        this.showStage = config.getBoolean("Stage", "dragon_mounts", true, "If this is enabled, the hud will show the current stage of the dragon.");
        this.showAdultTimer = config.getBoolean("AdultTimer", "dragon_mounts", true, "If this is enabled, the hud will show the time until the dragon is fully grown.");
        this.showStageTimer = config.getBoolean("StageTimer", "dragon_mounts", true, "If this is enabled, the hud will show the time until the dragon enters the next stage.");
    }

    @Override
    @Optional.Method(modid="DragonMounts")
    public void addEntityInfo(List<String> info, InfoAccess data) {
        if (data.entity instanceof EntityTameableDragon) {
            int time;
            EntityTameableDragon dragon = (EntityTameableDragon)data.entity;
            if (this.showStage) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.dragonmounts.stage", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("tooltip.wawla.dragonmounts.stage." + dragon.getLifeStageHelper().getLifeStage().name().toLowerCase()), (Object[])new Object[0]));
            }
            if (this.showAdultTimer && (time = this.maxTime - dragon.getLifeStageHelper().getTicksSinceCreation()) > 0 && dragon.getLifeStageHelper().getTicksSinceCreation() < this.maxTime) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.dragonmounts.adulttime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)time));
            }
            if (this.showStageTimer && (time = this.ticksUntilNextStage(dragon.getLifeStageHelper().getTicksSinceCreation())) > 0 && dragon.getLifeStageHelper().getTicksSinceCreation() < this.maxTime) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.dragonmounts.nexttime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)time));
            }
        }
    }

    private int ticksUntilNextStage(int currentTicks) {
        return 24000 - currentTicks % 24000;
    }
}

