/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.init;

import cofh.core.fluid.BlockFluidCore;
import cofh.core.fluid.FluidCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.fluid.BlockFluidAerotheum;
import cofh.thermalfoundation.fluid.BlockFluidCrudeOil;
import cofh.thermalfoundation.fluid.BlockFluidCryotheum;
import cofh.thermalfoundation.fluid.BlockFluidEnder;
import cofh.thermalfoundation.fluid.BlockFluidGlowstone;
import cofh.thermalfoundation.fluid.BlockFluidMana;
import cofh.thermalfoundation.fluid.BlockFluidPetrotheum;
import cofh.thermalfoundation.fluid.BlockFluidPyrotheum;
import cofh.thermalfoundation.fluid.BlockFluidRedstone;
import java.util.ArrayList;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TFFluids {
    private static ArrayList<IInitializer> initList = new ArrayList();
    public static Fluid fluidSteam;
    public static Fluid fluidCreosote;
    public static Fluid fluidCoal;
    public static Fluid fluidCrudeOil;
    public static Fluid fluidRefinedOil;
    public static Fluid fluidFuel;
    public static Fluid fluidSap;
    public static Fluid fluidSyrup;
    public static Fluid fluidResin;
    public static Fluid fluidTreeOil;
    public static Fluid fluidRedstone;
    public static Fluid fluidGlowstone;
    public static Fluid fluidEnder;
    public static Fluid fluidPyrotheum;
    public static Fluid fluidCryotheum;
    public static Fluid fluidAerotheum;
    public static Fluid fluidPetrotheum;
    public static Fluid fluidMana;
    public static BlockFluidCore blockFluidCrudeOil;
    public static BlockFluidCore blockFluidRedstone;
    public static BlockFluidCore blockFluidGlowstone;
    public static BlockFluidCore blockFluidEnder;
    public static BlockFluidCore blockFluidPyrotheum;
    public static BlockFluidCore blockFluidCryotheum;
    public static BlockFluidCore blockFluidAerotheum;
    public static BlockFluidCore blockFluidPetrotheum;
    public static BlockFluidCore blockFluidMana;

    private TFFluids() {
    }

    public static void preInit() {
        TFFluids.registerAllFluids();
        TFFluids.registerAllFluidBlocks();
        TFFluids.createBuckets();
        for (IInitializer init : initList) {
            init.preInit();
        }
    }

    public static void initialize() {
        for (IInitializer init : initList) {
            init.initialize();
        }
    }

    public static void postInit() {
        for (IInitializer init : initList) {
            init.postInit();
        }
        initList.clear();
    }

    public static void registerAllFluids() {
        FluidRegistry.registerFluid((Fluid)new FluidCore("steam", "thermalfoundation").setDensity(-1000).setViscosity(200).setTemperature(750).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new FluidCore("creosote", "thermalfoundation").setDensity(1100).setViscosity(2000));
        FluidRegistry.registerFluid((Fluid)new FluidCore("coal", "thermalfoundation").setDensity(900).setViscosity(2000));
        FluidRegistry.registerFluid((Fluid)new FluidCore("crude_oil", "thermalfoundation").setDensity(900).setViscosity(2000));
        FluidRegistry.registerFluid((Fluid)new FluidCore("refined_oil", "thermalfoundation").setDensity(800).setViscosity(1400));
        FluidRegistry.registerFluid((Fluid)new FluidCore("fuel", "thermalfoundation").setDensity(700).setViscosity(800));
        FluidRegistry.registerFluid((Fluid)new FluidCore("sap", "thermalfoundation").setDensity(1050).setViscosity(1500));
        FluidRegistry.registerFluid((Fluid)new FluidCore("syrup", "thermalfoundation").setDensity(1400).setViscosity(2500));
        FluidRegistry.registerFluid((Fluid)new FluidCore("resin", "thermalfoundation").setDensity(900).setViscosity(3000));
        FluidRegistry.registerFluid((Fluid)new FluidCore("tree_oil", "thermalfoundation").setDensity(900).setViscosity(1200));
        FluidRegistry.registerFluid((Fluid)new FluidCore("redstone", "thermalfoundation").setLuminosity(7).setDensity(1200).setViscosity(1500).setRarity(EnumRarity.UNCOMMON));
        FluidRegistry.registerFluid((Fluid)new FluidCore("glowstone", "thermalfoundation").setLuminosity(15).setDensity(-500).setViscosity(100).setGaseous(true).setRarity(EnumRarity.UNCOMMON));
        FluidRegistry.registerFluid((Fluid)new FluidCore("ender", "thermalfoundation").setLuminosity(3).setDensity(4000).setViscosity(2500).setRarity(EnumRarity.UNCOMMON));
        FluidRegistry.registerFluid((Fluid)new FluidCore("pyrotheum", "thermalfoundation").setLuminosity(15).setDensity(2000).setViscosity(1200).setTemperature(4000).setRarity(EnumRarity.RARE));
        FluidRegistry.registerFluid((Fluid)new FluidCore("cryotheum", "thermalfoundation").setDensity(4000).setViscosity(4000).setTemperature(50).setRarity(EnumRarity.RARE));
        FluidRegistry.registerFluid((Fluid)new FluidCore("aerotheum", "thermalfoundation").setDensity(-800).setViscosity(100).setGaseous(true).setRarity(EnumRarity.RARE));
        FluidRegistry.registerFluid((Fluid)new FluidCore("petrotheum", "thermalfoundation").setDensity(4000).setViscosity(1500).setTemperature(350).setRarity(EnumRarity.RARE));
        FluidRegistry.registerFluid((Fluid)new FluidCore("mana", "thermalfoundation").setLuminosity(15).setDensity(600).setViscosity(6000).setTemperature(350).setRarity(EnumRarity.EPIC));
        fluidSteam = FluidRegistry.getFluid((String)"steam");
        fluidCreosote = FluidRegistry.getFluid((String)"creosote");
        fluidCoal = FluidRegistry.getFluid((String)"coal");
        fluidCrudeOil = FluidRegistry.getFluid((String)"crude_oil");
        fluidRefinedOil = FluidRegistry.getFluid((String)"refined_oil");
        fluidFuel = FluidRegistry.getFluid((String)"fuel");
        fluidSap = FluidRegistry.getFluid((String)"sap");
        fluidSyrup = FluidRegistry.getFluid((String)"syrup");
        fluidResin = FluidRegistry.getFluid((String)"resin");
        fluidTreeOil = FluidRegistry.getFluid((String)"tree_oil");
        fluidRedstone = FluidRegistry.getFluid((String)"redstone");
        fluidGlowstone = FluidRegistry.getFluid((String)"glowstone");
        fluidEnder = FluidRegistry.getFluid((String)"ender");
        fluidPyrotheum = FluidRegistry.getFluid((String)"pyrotheum");
        fluidCryotheum = FluidRegistry.getFluid((String)"cryotheum");
        fluidAerotheum = FluidRegistry.getFluid((String)"aerotheum");
        fluidPetrotheum = FluidRegistry.getFluid((String)"petrotheum");
        fluidMana = FluidRegistry.getFluid((String)"mana");
    }

    public static void registerAllFluidBlocks() {
        blockFluidCrudeOil = new BlockFluidCrudeOil(fluidCrudeOil);
        blockFluidRedstone = new BlockFluidRedstone(fluidRedstone);
        blockFluidGlowstone = new BlockFluidGlowstone(fluidGlowstone);
        blockFluidEnder = new BlockFluidEnder(fluidEnder);
        blockFluidPyrotheum = new BlockFluidPyrotheum(fluidPyrotheum);
        blockFluidCryotheum = new BlockFluidCryotheum(fluidCryotheum);
        blockFluidAerotheum = new BlockFluidAerotheum(fluidAerotheum);
        blockFluidPetrotheum = new BlockFluidPetrotheum(fluidPetrotheum);
        blockFluidMana = new BlockFluidMana(fluidMana);
        initList.add((IInitializer)blockFluidCrudeOil);
        initList.add((IInitializer)blockFluidRedstone);
        initList.add((IInitializer)blockFluidGlowstone);
        initList.add((IInitializer)blockFluidEnder);
        initList.add((IInitializer)blockFluidPyrotheum);
        initList.add((IInitializer)blockFluidCryotheum);
        initList.add((IInitializer)blockFluidAerotheum);
        initList.add((IInitializer)blockFluidPetrotheum);
        initList.add((IInitializer)blockFluidMana);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidCrudeOil);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidRedstone);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidGlowstone);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidEnder);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidPyrotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidCryotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidAerotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidPetrotheum);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)blockFluidMana);
    }

    public static void createBuckets() {
        FluidRegistry.addBucketForFluid((Fluid)fluidSteam);
        FluidRegistry.addBucketForFluid((Fluid)fluidCreosote);
        FluidRegistry.addBucketForFluid((Fluid)fluidCoal);
        FluidRegistry.addBucketForFluid((Fluid)fluidCrudeOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidRefinedOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidFuel);
        FluidRegistry.addBucketForFluid((Fluid)fluidSap);
        FluidRegistry.addBucketForFluid((Fluid)fluidSyrup);
        FluidRegistry.addBucketForFluid((Fluid)fluidResin);
        FluidRegistry.addBucketForFluid((Fluid)fluidTreeOil);
        FluidRegistry.addBucketForFluid((Fluid)fluidRedstone);
        FluidRegistry.addBucketForFluid((Fluid)fluidGlowstone);
        FluidRegistry.addBucketForFluid((Fluid)fluidEnder);
        FluidRegistry.addBucketForFluid((Fluid)fluidPyrotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidCryotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidAerotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidPetrotheum);
        FluidRegistry.addBucketForFluid((Fluid)fluidMana);
    }
}

