/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.entity.monster;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.entity.monster.EntityElemental;
import cofh.thermalfoundation.entity.projectile.EntityBlizzBolt;
import cofh.thermalfoundation.init.TFSounds;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityBlizz
extends EntityElemental {
    static boolean enable = true;
    static boolean restrictLightLevel = true;
    static int spawnLightLevel = 8;
    static int spawnWeight = 10;
    static int spawnMin = 1;
    static int spawnMax = 4;
    public static boolean effect = true;

    public static void initialize(int id) {
        EntityBlizz.config();
        EntityRegistry.registerModEntity(EntityBlizz.class, (String)"blizz", (int)id, (Object)ThermalFoundation.instance, (int)64, (int)1, (boolean)true, (int)14744575, (int)7071487);
        ArrayList<Biome> validBiomes = new ArrayList<Biome>(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.COLD)));
        for (Biome biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            if (validBiomes.contains(biome)) continue;
            validBiomes.add(biome);
        }
        for (Biome biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            if (!validBiomes.contains(biome)) continue;
            validBiomes.remove(biome);
        }
        if (!enable) {
            return;
        }
        EntityRegistry.addSpawn(EntityBlizz.class, (int)spawnWeight, (int)spawnMin, (int)spawnMax, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])validBiomes.toArray(new Biome[validBiomes.size()]));
    }

    public static void config() {
        String category = "Mob.Blizz";
        String comment = "If TRUE, Blizzes will spawn naturally.";
        enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Enable", category, enable, comment);
        comment = "If TRUE, Blizzes will only spawn below a specified light level.";
        restrictLightLevel = ThermalFoundation.CONFIG.getConfiguration().getBoolean("LightLevelRestriction", category, restrictLightLevel, comment);
        comment = "This sets the maximum light level Blizzes can spawn at, if restricted.";
        spawnLightLevel = ThermalFoundation.CONFIG.getConfiguration().getInt("LightLevel", category, spawnLightLevel, 0, 15, comment);
        comment = "This sets the minimum number of Blizzes that spawn in a group.";
        spawnMin = ThermalFoundation.CONFIG.getConfiguration().getInt("MinGroupSize", category, spawnMin, 1, 10, comment);
        comment = "This sets the maximum number of Blizzes that spawn in a group.";
        spawnMax = ThermalFoundation.CONFIG.getConfiguration().getInt("MaxGroupSize", category, spawnMax, spawnMin, 24, comment);
        comment = "This sets the relative spawn weight for Blizzes.";
        spawnWeight = ThermalFoundation.CONFIG.getConfiguration().getInt("SpawnWeight", category, spawnWeight, 1, 20, comment);
        comment = "If TRUE, Blizz attacks will inflict Slowness.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
    }

    public EntityBlizz(World world) {
        super(world);
        this.ambientParticle = EnumParticleTypes.SNOWBALL;
        this.ambientSound = TFSounds.BLIZZ_AMBIENT;
    }

    protected void func_70628_a(boolean wasHitByPlayer, int looting) {
        if (wasHitByPlayer) {
            int i;
            int items = this.field_70146_Z.nextInt(4 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70099_a(new ItemStack(Items.field_151126_ay), 0.0f);
            }
            items = this.field_70146_Z.nextInt(2 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70099_a(ItemHelper.cloneStack((ItemStack)ItemMaterial.rodBlizz, (int)1), 0.0f);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBlizzballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected boolean restrictLightLevel() {
        return restrictLightLevel;
    }

    @Override
    protected int getSpawnLightLevel() {
        return spawnLightLevel;
    }

    static class AIBlizzballAttack
    extends EntityAIBase {
        private final EntityBlizz blizz;
        private int attackStep;
        private int attackTime;

        public AIBlizzballAttack(EntityBlizz entity) {
            this.blizz = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.blizz.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.blizz.setInAttackMode(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase target = this.blizz.func_70638_az();
            double d0 = this.blizz.func_70068_e((Entity)target);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blizz.func_70652_k((Entity)target);
                }
                this.blizz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            } else if (d0 < 256.0) {
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.blizz.setInAttackMode(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.blizz.setInAttackMode(false);
                    }
                    if (this.attackStep > 1) {
                        this.blizz.field_70170_p.func_180498_a(null, 1009, new BlockPos((int)this.blizz.field_70165_t, (int)this.blizz.field_70163_u, (int)this.blizz.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntityBlizzBolt bolt = new EntityBlizzBolt(this.blizz.field_70170_p, (EntityLivingBase)this.blizz);
                            bolt.field_70163_u = this.blizz.field_70163_u + (double)(this.blizz.field_70131_O / 2.0f) + 0.5;
                            bolt.func_70186_c(target.field_70165_t - this.blizz.field_70165_t, target.field_70163_u - this.blizz.field_70163_u, target.field_70161_v - this.blizz.field_70161_v, 1.5f, 1.0f);
                            this.blizz.func_184185_a(TFSounds.BLIZZ_ATTACK, 2.0f, (this.blizz.field_70146_Z.nextFloat() - this.blizz.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                            this.blizz.field_70170_p.func_72838_d((Entity)bolt);
                        }
                    }
                }
                this.blizz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
            } else {
                this.blizz.func_70661_as().func_75499_g();
                this.blizz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }
}

