/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.proxy;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.ModBlocks;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.entity.EntityGhostPlayer;
import de.maxhenkel.gravestone.events.BlockEvents;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.events.UpdateCheckEvents;
import de.maxhenkel.gravestone.gui.GuiHandler;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class CommonProxy {
    public void preinit(FMLPreInitializationEvent event) {
        Configuration c = null;
        try {
            c = new Configuration(event.getSuggestedConfigurationFile());
            Config config = new Config(c);
            config.setInstance();
        }
        catch (Exception e) {
            Log.w("Could not create config file: " + e.getMessage());
        }
        Log.setLogger(event.getModLog());
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UpdateCheckEvents());
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        this.registerBlock((Block)ModBlocks.GRAVESTONE);
        this.registerItem(ModItems.DEATH_INFO);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance(), (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileEntityGraveStone.class, (String)"TileEntityGaveStone");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.GRAVESTONE), (Object[])new Object[]{"CXX", "CXX", "DDD", Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('D'), Blocks.field_150346_d});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.GRAVESTONE), (Object[])new Object[]{"XXC", "XXC", "DDD", Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('D'), Blocks.field_150346_d});
        EntityRegistry.registerModEntity(EntityGhostPlayer.class, (String)"player_ghost", (int)378, (Object)Main.instance(), (int)32, (int)1, (boolean)true);
    }

    public void postinit(FMLPostInitializationEvent event) {
    }

    private void registerItem(Item i) {
        GameRegistry.register((IForgeRegistryEntry)i);
    }

    private void registerBlock(Block b) {
        GameRegistry.register((IForgeRegistryEntry)b);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(b).setRegistryName(b.getRegistryName()));
    }
}

