/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks.door;

import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.door.DoorType;
import greymerk.roguelike.worldgen.blocks.door.IDoor;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class Door
implements IDoor {
    MetaBlock block;

    public Door(MetaBlock block) {
        this.block = block;
    }

    public Door(DoorType type) {
        this.block = DoorType.get(type);
    }

    public Door(JsonElement e) {
        this.block = new MetaBlock(e);
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir) {
        Door.generate(editor, this.block, pos, dir, false);
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir, boolean open) {
        Door.generate(editor, this.block, pos, dir, open);
    }

    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, DoorType type) {
        MetaBlock door = DoorType.get(type);
        Door.generate(editor, door, pos, dir, false);
    }

    public static void generate(IWorldEditor editor, MetaBlock door, Coord pos, Cardinal dir, boolean open) {
        Coord cursor = new Coord(pos);
        MetaBlock doorBase = Door.setProperties(door, false, dir, open, false);
        doorBase.set(editor, cursor);
        cursor.add(Cardinal.UP);
        MetaBlock doorTop = Door.setProperties(door, true, dir, open, false);
        doorTop.set(editor, cursor);
    }

    private static MetaBlock setProperties(MetaBlock doorblock, boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        IBlockState door = doorblock.func_177230_c().func_176223_P();
        door = door.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(top ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER));
        door = door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)Cardinal.facing(dir));
        door = door.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(open));
        door = door.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(hingeLeft ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT));
        return new MetaBlock(door);
    }
}

