/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MetaBlock
extends BlockBase
implements IBlockState {
    private IBlockState state;
    private int flag;

    public MetaBlock(Block block) {
        this.state = block.func_176223_P();
        this.flag = 2;
    }

    public MetaBlock(IBlockState state) {
        this.state = state;
        this.flag = 2;
    }

    public MetaBlock(Block block, IProperty<?> ... properties) {
        BlockStateContainer s = new BlockStateContainer(block, properties);
        this.state = s.func_177621_b();
    }

    public MetaBlock(JsonElement e) {
        JsonObject json = (JsonObject)e;
        String name = json.get("name").getAsString();
        ResourceLocation location = new ResourceLocation(name);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        int meta = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.state = block.func_176203_a(meta);
        this.flag = json.has("flag") ? json.get("flag").getAsInt() : 2;
    }

    public void setState(IBlockState state) {
        this.state = state;
    }

    public boolean set(IWorldEditor editor, Coord pos) {
        return editor.setBlock(pos, this, true, true);
    }

    @Override
    public boolean set(IWorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        return editor.setBlock(pos, this, fillAir, replaceSolid);
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        this.state = this.state.func_177226_a(property, value);
        return this.state;
    }

    public <T extends Comparable<T>> IBlockState func_177231_a(IProperty<T> property) {
        return this.state.func_177231_a(property);
    }

    public IBlockState getState() {
        return this.state;
    }

    public Block func_177230_c() {
        return this.state.func_177230_c();
    }

    public int getFlag() {
        return this.flag;
    }

    public String toString() {
        return this.state.func_177230_c().func_149739_a();
    }

    public Material func_185904_a() {
        return this.state.func_185904_a();
    }

    public boolean func_185913_b() {
        return this.state.func_185913_b();
    }

    public boolean func_185916_f() {
        return this.state.func_185916_f();
    }

    public MapColor func_185909_g() {
        return this.state.func_185909_g();
    }

    public IBlockState func_185907_a(Rotation rot) {
        return this.state.func_185907_a(rot);
    }

    public IBlockState func_185902_a(Mirror mirrorIn) {
        return this.state.func_185902_a(mirrorIn);
    }

    public boolean func_185917_h() {
        return this.state.func_185917_h();
    }

    public EnumBlockRenderType func_185901_i() {
        return this.state.func_185901_i();
    }

    public boolean func_185898_k() {
        return this.state.func_185898_k();
    }

    public boolean func_185915_l() {
        return this.state.func_185915_l();
    }

    public boolean func_185897_m() {
        return this.state.func_185897_m();
    }

    public int func_185911_a(IBlockAccess p_185911_1_, BlockPos p_185911_2_, EnumFacing p_185911_3_) {
        return this.state.func_185911_a(p_185911_1_, p_185911_2_, p_185911_3_);
    }

    public boolean func_185912_n() {
        return this.state.func_185912_n();
    }

    public int func_185888_a(World p_185888_1_, BlockPos p_185888_2_) {
        return this.state.func_185888_a(p_185888_1_, p_185888_2_);
    }

    public float func_185887_b(World p_185887_1_, BlockPos p_185887_2_) {
        return this.state.func_185887_b(p_185887_1_, p_185887_2_);
    }

    public float func_185903_a(EntityPlayer p_185903_1_, World p_185903_2_, BlockPos p_185903_3_) {
        return this.state.func_185903_a(p_185903_1_, p_185903_2_, p_185903_3_);
    }

    public int func_185893_b(IBlockAccess p_185893_1_, BlockPos p_185893_2_, EnumFacing p_185893_3_) {
        return this.state.func_185893_b(p_185893_1_, p_185893_2_, p_185893_3_);
    }

    public EnumPushReaction func_185905_o() {
        return this.state.func_185905_o();
    }

    public IBlockState func_185899_b(IBlockAccess p_185899_1_, BlockPos p_185899_2_) {
        return this.state.func_185899_b(p_185899_1_, p_185899_2_);
    }

    public boolean func_185914_p() {
        return this.state.func_185914_p();
    }

    public AxisAlignedBB func_185918_c(World p_185890_1_, BlockPos p_185890_2_) {
        return this.state.func_185918_c(p_185890_1_, p_185890_2_);
    }

    public Collection<IProperty<?>> func_177227_a() {
        return this.state.func_177227_a();
    }

    public ImmutableMap<IProperty<?>, Comparable<?>> func_177228_b() {
        return this.state.func_177228_b();
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.state.getLightOpacity(world, pos);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return this.state.getLightValue(world, pos);
    }

    public boolean func_185895_e() {
        return this.state.func_185895_e();
    }

    public int func_185889_a(IBlockAccess source, BlockPos pos) {
        return this.state.func_185889_a(source, pos);
    }

    public float func_185892_j() {
        return this.state.func_185892_j();
    }

    public AxisAlignedBB func_185890_d(World worldIn, BlockPos pos) {
        return this.state.func_185890_d(worldIn, pos);
    }

    public boolean func_185894_c(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing) {
        return this.state.func_185894_c(blockAccess, pos, facing);
    }

    public void func_185908_a(World worldIn, BlockPos pos, AxisAlignedBB p_185908_3_, List<AxisAlignedBB> p_185908_4_, Entity p_185908_5_) {
        this.state.func_185908_a(worldIn, pos, p_185908_3_, p_185908_4_, p_185908_5_);
    }

    public AxisAlignedBB func_185900_c(IBlockAccess blockAccess, BlockPos pos) {
        return this.state.func_185900_c(blockAccess, pos);
    }

    public RayTraceResult func_185910_a(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.state.func_185910_a(worldIn, pos, start, end);
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.doesSideBlockRendering(world, pos, side);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.isSideSolid(world, pos, side);
    }

    public boolean func_185896_q() {
        return this.state.func_185896_q();
    }

    public int func_185891_c() {
        return this.state.func_185891_c();
    }

    public void func_189546_a(World arg0, BlockPos arg1, Block arg2) {
        this.state.func_189546_a(arg0, arg1, arg2);
    }

    public boolean func_189547_a(World arg0, BlockPos arg1, int arg2, int arg3) {
        return this.state.func_189547_a(arg0, arg1, arg2, arg3);
    }

    public int func_185906_d() {
        return this.state.func_185906_d();
    }

    public boolean func_189884_a(Entity entityIn) {
        return this.state.func_189884_a(entityIn);
    }

    public boolean equals(Object other) {
        if (!(other instanceof MetaBlock)) {
            IBlockState otherBlock = (IBlockState)other;
            return this.state.equals(otherBlock);
        }
        MetaBlock otherBlock = (MetaBlock)other;
        return this.state.equals(otherBlock.state);
    }
}

