/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSpecialty
extends ItemBase {
    private Equipment type;
    private Quality quality;

    public ItemSpecialty(int weight, int level) {
        super(weight, level);
    }

    public ItemSpecialty(int weight, int level, Equipment type, Quality q) {
        super(weight, level);
        this.type = type;
        this.quality = q;
    }

    public ItemSpecialty(int weight, int level, Quality q) {
        super(weight, level);
        this.quality = q;
    }

    @Override
    public ItemStack get(Random rand) {
        if (this.type == null && this.quality != null) {
            return ItemSpecialty.getRandomItem(Equipment.values()[rand.nextInt(Equipment.values().length)], rand, this.quality);
        }
        if (this.type == null || this.quality == null) {
            return ItemSpecialty.getRandomItem(rand, this.level);
        }
        return ItemSpecialty.getRandomItem(this.type, rand, this.quality);
    }

    public static ItemStack getRandomItem(Random rand, int level) {
        return ItemSpecialty.getRandomItem(Equipment.values()[rand.nextInt(Equipment.values().length)], rand, level);
    }

    public static ItemStack getRandomItem(Equipment type, Random rand, int level) {
        return ItemSpecialty.getRandomItem(type, rand, Quality.get(rand, level, type));
    }

    public static ItemStack getRandomItem(Equipment type, Random rand, Quality quality) {
        switch (type) {
            case SWORD: {
                return ItemSpecialty.getSword(rand, quality);
            }
            case BOW: {
                return ItemSpecialty.getBow(rand, quality);
            }
            case HELMET: {
                return ItemSpecialty.getHelmet(rand, quality);
            }
            case CHEST: {
                return ItemSpecialty.getChest(rand, quality);
            }
            case LEGS: {
                return ItemSpecialty.getLegs(rand, quality);
            }
            case FEET: {
                return ItemSpecialty.getBoots(rand, quality);
            }
            case PICK: {
                return ItemSpecialty.getPick(rand, quality);
            }
            case AXE: {
                return ItemSpecialty.getAxe(rand, quality);
            }
            case SHOVEL: {
                return ItemSpecialty.getShovel(rand, quality);
            }
        }
        return null;
    }

    public static ItemStack getRandomArmour(Random rand, Quality quality) {
        switch (rand.nextInt(4)) {
            case 0: {
                return ItemSpecialty.getRandomItem(Equipment.HELMET, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(Equipment.CHEST, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(Equipment.LEGS, rand, quality);
            }
            case 3: {
                return ItemSpecialty.getRandomItem(Equipment.FEET, rand, quality);
            }
        }
        return null;
    }

    public static ItemStack getRandomTool(Random rand, Quality quality) {
        switch (rand.nextInt(3)) {
            case 0: {
                return ItemSpecialty.getRandomItem(Equipment.PICK, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(Equipment.AXE, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(Equipment.SHOVEL, rand, quality);
            }
        }
        return null;
    }

    private static ItemStack getShovel(Random rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            ItemStack item = new ItemStack(Items.field_151047_v);
            item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 3 + rand.nextInt(3));
            item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            Loot.setItemName(item, "Soul Spade");
            return item;
        }
        ItemStack item = new ItemStack(Items.field_151037_a);
        item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 1 + rand.nextInt(2));
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        Loot.setItemName(item, "Grave Spade");
        return item;
    }

    private static ItemStack getAxe(Random rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            ItemStack item = new ItemStack(Items.field_151056_x);
            item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 3 + rand.nextInt(3));
            item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            Loot.setItemName(item, "Crystal Head Axe");
            return item;
        }
        ItemStack item = new ItemStack(Items.field_151036_c);
        item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 1 + rand.nextInt(2));
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        Loot.setItemName(item, "Woodland Hatchet");
        return item;
    }

    private static ItemStack getPick(Random rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            ItemStack item = new ItemStack(Items.field_151046_w);
            item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 3 + rand.nextInt(3));
            item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            if (rand.nextInt(10) == 0) {
                item.func_77966_a(Enchant.getEnchant(Enchant.SILKTOUCH), 1);
                Loot.setItemName(item, "Crystal Pick of Precision");
                return item;
            }
            if (rand.nextInt(10) == 0) {
                item.func_77966_a(Enchant.getEnchant(Enchant.FORTUNE), 2 + rand.nextInt(2));
                Loot.setItemName(item, "Crystal Pick of Prospecting");
                return item;
            }
            if (rand.nextInt(5) == 0) {
                item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
            }
            Loot.setItemName(item, "Crystal Pick");
            return item;
        }
        ItemStack item = new ItemStack(Items.field_151035_b);
        item.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), 1 + rand.nextInt(2));
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.SILKTOUCH), 1);
            Loot.setItemName(item, "Case Hardened Pick of Precision");
            return item;
        }
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.FORTUNE), 1 + rand.nextInt(3));
            Loot.setItemName(item, "Case Hardened Pick of Prospecting");
            return item;
        }
        if (rand.nextInt(5) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        }
        Loot.setItemName(item, "Case Hardened Pick");
        return item;
    }

    private static ItemStack getSword(Random rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            ItemStack item = new ItemStack(Items.field_151048_u);
            item.func_77966_a(Enchant.getEnchant(Enchant.SHARPNESS), 3 + rand.nextInt(3));
            if (rand.nextInt(10) == 0) {
                item.func_77966_a(Enchant.getEnchant(Enchant.LOOTING), 2 + rand.nextInt(2));
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                Loot.setItemName(item, "Eldritch Blade of Plundering");
                Loot.setItemLore(item, "The loot taker", TextFormat.DARKGREEN);
                return item;
            }
            if (rand.nextInt(10) == 0) {
                item.func_77966_a(Enchant.getEnchant(Enchant.FIREASPECT), 2 + rand.nextInt(2));
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                Loot.setItemName(item, "Eldritch Blade of the Inferno");
                Loot.setItemLore(item, "From the fiery depths", TextFormat.DARKGREEN);
                return item;
            }
            item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), quality == Quality.DIAMOND ? 3 : 1 + rand.nextInt(2));
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
            Loot.setItemName(item, "Eldritch Blade");
            Loot.setItemLore(item, "Rune Etched", TextFormat.DARKGREEN);
            return item;
        }
        ItemStack item = new ItemStack(Items.field_151040_l);
        if (rand.nextBoolean()) {
            item.func_77966_a(Enchant.getEnchant(Enchant.SHARPNESS), 1);
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), 3);
        item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        Loot.setItemName(item, "Tempered Blade");
        Loot.setItemLore(item, "Highly Durable", TextFormat.DARKGREEN);
        return item;
    }

    private static ItemStack getBow(Random rand, Quality quality) {
        ItemStack item = new ItemStack((Item)Items.field_151031_f);
        switch (quality) {
            case WOOD: 
            case STONE: {
                item.func_77966_a(Enchant.getEnchant(Enchant.POWER), 1 + rand.nextInt(3));
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), 1);
                Loot.setItemName(item, "Yew Longbow");
                Loot.setItemLore(item, "Superior craftsmanship", TextFormat.DARKGREEN);
                return item;
            }
            case IRON: {
                item.func_77966_a(Enchant.getEnchant(Enchant.POWER), 1 + rand.nextInt(3));
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), 1 + rand.nextInt(3));
                Loot.setItemName(item, "Laminated Bow");
                Loot.setItemLore(item, "Highly polished", TextFormat.DARKGREEN);
                return item;
            }
            case GOLD: {
                item.func_77966_a(Enchant.getEnchant(Enchant.POWER), 3 + rand.nextInt(3));
                if (rand.nextBoolean()) {
                    item.func_77966_a(Enchant.getEnchant(Enchant.INFINITY), 1);
                }
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), 1 + rand.nextInt(3));
                Loot.setItemName(item, "Recurve Bow");
                Loot.setItemLore(item, "Beautifully crafted", TextFormat.DARKGREEN);
                return item;
            }
            case DIAMOND: {
                item.func_77966_a(Enchant.getEnchant(Enchant.POWER), 3 + rand.nextInt(3));
                item.func_77966_a(Enchant.getEnchant(Enchant.FLAME), 1);
                item.func_77966_a(Enchant.getEnchant(Enchant.INFINITY), 1);
                item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
                Loot.setItemName(item, "Eldritch Bow");
                Loot.setItemLore(item, "Warm to the touch", TextFormat.DARKGREEN);
                return item;
            }
        }
        return null;
    }

    private static ItemStack getHelmet(Random rand, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151024_Q);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                canonical = "Bonnet";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151020_U);
                canonical = "Coif";
                break;
            }
            case IRON: 
            case GOLD: {
                item = new ItemStack((Item)Items.field_151028_Y);
                canonical = "Sallet";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151161_ac);
                canonical = "Helm";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151024_Q);
            }
        }
        String suffix = "";
        if (rand.nextInt(20) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            item.func_77966_a(Enchant.getEnchant(Enchant.RESPIRATION), 3);
            item.func_77966_a(Enchant.getEnchant(Enchant.AQUAAFFINITY), 1);
            suffix = "of Diving";
        } else if (rand.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static ItemStack getBoots(Random rand, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151021_T);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                canonical = "Shoes";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151029_X);
                canonical = "Greaves";
                break;
            }
            case IRON: 
            case GOLD: {
                item = new ItemStack((Item)Items.field_151167_ab);
                canonical = "Sabatons";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151175_af);
                canonical = "Boots";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151021_T);
                canonical = "Shoes";
            }
        }
        String suffix = "";
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Warding";
        } else if (rand.nextInt(5) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            item.func_77966_a(Enchant.getEnchant(Enchant.FEATHERFALLING), quality == Quality.DIAMOND ? 4 : 1 + rand.nextInt(3));
            suffix = "of Lightness";
        } else if (rand.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static ItemStack getLegs(Random rand, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151026_S);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                canonical = "Pantaloons";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151022_W);
                canonical = "Chausses";
                break;
            }
            case IRON: 
            case GOLD: {
                item = new ItemStack((Item)Items.field_151165_aa);
                canonical = "Leg-plates";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151173_ae);
                canonical = "Leggings";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151026_S);
            }
        }
        String suffix = "";
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Warding";
        } else if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Integrity";
        } else if (rand.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static ItemStack getChest(Random rand, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151027_R);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                canonical = "Tunic";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151023_V);
                canonical = "Hauberk";
                break;
            }
            case IRON: 
            case GOLD: {
                item = new ItemStack((Item)Items.field_151030_Z);
                canonical = "Cuirass";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151163_ad);
                canonical = "Plate";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151027_R);
                canonical = "Tunic";
            }
        }
        String suffix = "";
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Flamewarding";
        } else if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Integrity";
        } else if (rand.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static int getUnbreakingLevel(Quality quality, Random rand) {
        return quality == Quality.DIAMOND ? 3 : 1 + rand.nextInt(2);
    }

    private static int getProtectionLevel(Quality quality, Random rand) {
        int value = 1;
        switch (quality) {
            case WOOD: {
                if (rand.nextInt(3) != 0) break;
                ++value;
                break;
            }
            case STONE: {
                if (!rand.nextBoolean()) break;
                ++value;
                break;
            }
            case IRON: 
            case GOLD: {
                value += rand.nextInt(3);
                break;
            }
            case DIAMOND: {
                value += 2 + rand.nextInt(2);
            }
        }
        return value;
    }

    private static String getArmourPrefix(Quality quality) {
        switch (quality) {
            case WOOD: {
                return "Surplus";
            }
            case STONE: {
                return "Riveted";
            }
            case IRON: {
                return "Gothic";
            }
            case GOLD: {
                return "Jewelled";
            }
            case DIAMOND: {
                return "Crystal";
            }
        }
        return "Strange";
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        Quality q;
        switch (level) {
            case 0: {
                q = Quality.WOOD;
                break;
            }
            case 1: {
                q = Quality.STONE;
                break;
            }
            case 2: {
                q = Quality.IRON;
                break;
            }
            case 3: {
                q = Quality.GOLD;
                break;
            }
            case 4: {
                q = Quality.DIAMOND;
                break;
            }
            default: {
                q = Quality.WOOD;
            }
        }
        return ItemSpecialty.getRandomItem(Equipment.values()[rand.nextInt(Equipment.values().length)], rand, q);
    }
}

