/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemArmour
extends ItemBase {
    public ItemArmour(int weight, int level) {
        super(weight, level);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        return ItemArmour.getRandom(rand, level, true);
    }

    public static ItemStack getRandom(Random rand, int level, boolean enchant) {
        return ItemArmour.getRandom(rand, level, Slot.getSlotByNumber(rand.nextInt(4) + 1), enchant ? Enchant.getLevel(rand, level) : 0);
    }

    public static ItemStack getRandom(Random rand, int level, Slot slot, boolean enchant) {
        return ItemArmour.getRandom(rand, level, slot, enchant ? Enchant.getLevel(rand, level) : 0);
    }

    public static ItemStack getRandom(Random rand, int level, Slot slot, int enchantLevel) {
        if (enchantLevel > 0 && rand.nextInt(20 + level * 10) == 0) {
            switch (slot) {
                case HEAD: {
                    return ItemSpecialty.getRandomItem(Equipment.HELMET, rand, level);
                }
                case CHEST: {
                    return ItemSpecialty.getRandomItem(Equipment.CHEST, rand, level);
                }
                case LEGS: {
                    return ItemSpecialty.getRandomItem(Equipment.LEGS, rand, level);
                }
                case FEET: {
                    return ItemSpecialty.getRandomItem(Equipment.FEET, rand, level);
                }
            }
        }
        ItemStack item = ItemArmour.get(rand, slot, Quality.getArmourQuality(rand, level));
        if (enchantLevel > 0) {
            Enchant.enchantItem(rand, item, enchantLevel);
        }
        return item;
    }

    public static ItemStack get(Random rand, Slot slot, Quality quality) {
        switch (slot) {
            case HEAD: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151161_ac);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151169_ag);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151028_Y);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151020_U);
                    }
                }
                ItemStack item = new ItemStack((Item)Items.field_151024_Q);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                return item;
            }
            case FEET: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151175_af);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151151_aj);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151167_ab);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151029_X);
                    }
                }
                ItemStack item = new ItemStack((Item)Items.field_151021_T);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                return item;
            }
            case CHEST: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151163_ad);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151171_ah);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151030_Z);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151023_V);
                    }
                }
                ItemStack item = new ItemStack((Item)Items.field_151027_R);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                return item;
            }
            case LEGS: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151173_ae);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151149_ai);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151165_aa);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151022_W);
                    }
                }
                ItemStack item = new ItemStack((Item)Items.field_151026_S);
                ItemArmour.dyeArmor(item, rand.nextInt(256), rand.nextInt(255), rand.nextInt(255));
                return item;
            }
        }
        return null;
    }

    public static ItemStack dyeArmor(ItemStack armor, int r, int g, int b) {
        int color = r << 16 | g << 8 | b << 0;
        NBTTagCompound nbtdata = armor.func_77978_p();
        if (nbtdata == null) {
            nbtdata = new NBTTagCompound();
            armor.func_77982_d(nbtdata);
        }
        NBTTagCompound nbtDisplay = nbtdata.func_74775_l("display");
        if (!nbtdata.func_74764_b("display")) {
            nbtdata.func_74782_a("display", (NBTBase)nbtDisplay);
        }
        nbtDisplay.func_74768_a("color", color);
        return armor;
    }
}

