/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsSwampTheme
extends DungeonSettings {
    public SettingsSwampTheme() {
        int i;
        this.id = new SettingIdentifier("builtin", "swamp");
        this.criteria = new SpawnCriteria();
        ArrayList<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
        biomes.add(BiomeDictionary.Type.SWAMP);
        this.criteria.setBiomeTypes(biomes);
        this.towerSettings = new TowerSettings(Tower.WITCH, Theme.getTheme(Theme.DARKOAK));
        Theme[] themes = new Theme[]{Theme.DARKHALL, Theme.DARKHALL, Theme.MUDDY, Theme.MOSSY, Theme.NETHER};
        WeightedRandomizer<ItemStack> brewing = new WeightedRandomizer<ItemStack>();
        brewing.add(new WeightedRandomLoot(Items.field_151069_bo, 0, 1, 3, 3));
        brewing.add(new WeightedRandomLoot(Items.field_151064_bs, 0, 1, 2, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151060_bw, 0, 1, 3, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151065_br, 0, 1, 3, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151102_aT, 0, 1, 3, 1));
        this.lootRules = new LootRuleManager();
        for (i = 0; i < 5; ++i) {
            this.lootRules.add(null, brewing, i, true, 2);
            this.lootRules.add(null, new WeightedRandomLoot(Items.field_151123_aH, 0, 1, 1 + i, 1), i, false, 4 + i * 3);
        }
        for (i = 0; i < 5; ++i) {
            DungeonFactory factory;
            SegmentGenerator segments;
            LevelSettings level = new LevelSettings();
            level.setTheme(Theme.getTheme(themes[i]));
            if (i == 0) {
                segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 8);
                segments.add(Segment.LAMP, 2);
                segments.add(Segment.FLOWERS, 1);
                segments.add(Segment.MUSHROOM, 2);
                level.setSegments(segments);
                factory = new DungeonFactory();
                factory.addSingle(DungeonRoom.CAKE);
                factory.addSingle(DungeonRoom.DARKHALL);
                factory.addRandom(DungeonRoom.BRICK, 10);
                factory.addRandom(DungeonRoom.CORNER, 3);
                level.setRooms(factory);
            }
            if (i == 1) {
                segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 8);
                segments.add(Segment.SHELF, 4);
                segments.add(Segment.INSET, 4);
                segments.add(Segment.MUSHROOM, 3);
                level.setSegments(segments);
                factory = new DungeonFactory();
                factory.addSingle(DungeonRoom.CAKE);
                factory.addSingle(DungeonRoom.LAB);
                factory.addSingle(DungeonRoom.SPIDER);
                factory.addSingle(DungeonRoom.PIT);
                factory.addSingle(DungeonRoom.PRISON);
                factory.addRandom(DungeonRoom.BRICK, 10);
                factory.addRandom(DungeonRoom.CORNER, 3);
                level.setRooms(factory);
            }
            this.levels.put(i, level);
        }
    }
}

