/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpawnCriteria {
    int weight = 1;
    List<String> biomes = new ArrayList<String>();
    List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    boolean everywhere = false;

    public SpawnCriteria() {
    }

    public SpawnCriteria(JsonObject data) {
        this();
        int n = this.weight = data.has("weight") ? data.get("weight").getAsInt() : 1;
        if (data.has("biomes")) {
            JsonArray biomeList = data.get("biomes").getAsJsonArray();
            this.biomes = new ArrayList<String>();
            for (JsonElement e : biomeList) {
                String name = e.getAsString();
                this.biomes.add(name);
            }
        }
        if (data.has("biomeTypes")) {
            JsonArray biomeTypeList = data.get("biomeTypes").getAsJsonArray();
            this.biomeTypes = new ArrayList<BiomeDictionary.Type>();
            for (JsonElement e : biomeTypeList) {
                String type = e.getAsString();
                this.biomeTypes.add(BiomeDictionary.Type.valueOf((String)type));
            }
        }
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setbiomes(List<String> biomes) {
        this.biomes = biomes;
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public void setBiomeTypes(List<BiomeDictionary.Type> biomeTypes) {
        this.biomeTypes = biomeTypes;
        this.everywhere = this.biomes.isEmpty() && this.biomeTypes.isEmpty();
    }

    public boolean isValid(IWorldEditor editor, Coord pos) {
        if (this.everywhere) {
            return true;
        }
        boolean biomeFound = false;
        Biome biome = editor.getBiome(pos);
        if (this.biomes != null && this.biomes.contains(biome.func_185359_l())) {
            biomeFound = true;
        }
        if (this.biomeTypes != null) {
            for (BiomeDictionary.Type type : this.biomeTypes) {
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                biomeFound = true;
            }
        }
        return biomeFound;
    }

    public static boolean isValidDimension(int dim, List<Integer> wl, List<Integer> bl) {
        if (bl.contains(dim)) {
            return false;
        }
        if (wl.isEmpty()) {
            return true;
        }
        return wl.contains(dim);
    }
}

