/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsBlank;
import greymerk.roguelike.dungeon.settings.SettingsContainer;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.builtin.SettingsDesertTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsForestTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsGenerator;
import greymerk.roguelike.dungeon.settings.builtin.SettingsGrasslandTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsIceTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsJungleTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsLootRules;
import greymerk.roguelike.dungeon.settings.builtin.SettingsMesaTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsMountainTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsRooms;
import greymerk.roguelike.dungeon.settings.builtin.SettingsSecrets;
import greymerk.roguelike.dungeon.settings.builtin.SettingsSegments;
import greymerk.roguelike.dungeon.settings.builtin.SettingsSize;
import greymerk.roguelike.dungeon.settings.builtin.SettingsSwampTheme;
import greymerk.roguelike.dungeon.settings.builtin.SettingsTheme;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Map;
import java.util.Random;

public class SettingsResolver {
    private SettingsContainer settings = new SettingsContainer();
    private DungeonSettings base;

    public SettingsResolver() throws Exception {
        DungeonSettings base = new SettingsBlank();
        base = new DungeonSettings(base, new SettingsRooms());
        base = new DungeonSettings(base, new SettingsSecrets());
        base = new DungeonSettings(base, new SettingsSegments());
        base = new DungeonSettings(base, new SettingsSize());
        base = new DungeonSettings(base, new SettingsTheme());
        base = new DungeonSettings(base, new SettingsGenerator());
        base = new DungeonSettings(base, new SettingsLootRules());
        base.setCriteria(new SpawnCriteria());
        this.base = base;
        this.settings.put(new SettingsDesertTheme());
        this.settings.put(new SettingsGrasslandTheme());
        this.settings.put(new SettingsJungleTheme());
        this.settings.put(new SettingsSwampTheme());
        this.settings.put(new SettingsMountainTheme());
        this.settings.put(new SettingsForestTheme());
        this.settings.put(new SettingsMesaTheme());
        this.settings.put(new SettingsIceTheme());
    }

    public void parseCustomSettings(Map<String, String> files) throws Exception {
        for (String name : files.keySet()) {
            DungeonSettings toAdd = null;
            try {
                toAdd = this.parseFile(files.get(name));
            }
            catch (Exception e) {
                throw new Exception("Error in: " + name + " : " + e.getMessage());
            }
            this.settings.put(toAdd);
        }
    }

    public ISettings getSettings(IWorldEditor editor, Random rand, Coord pos) {
        DungeonSettings builtin = this.getBuiltin(editor, rand, pos);
        DungeonSettings custom = this.getCustom(editor, rand, pos);
        if (builtin == null && custom == null) {
            return null;
        }
        DungeonSettings exclusive = custom != null ? custom : builtin;
        return new DungeonSettings(this.base, this.applyInclusives(exclusive, editor, rand, pos));
    }

    public ISettings getWithName(String name, IWorldEditor editor, Random rand, Coord pos) {
        DungeonSettings byName = this.getByName(name);
        if (byName == null) {
            return null;
        }
        DungeonSettings withInclusives = this.applyInclusives(byName, editor, rand, pos);
        return new DungeonSettings(this.base, withInclusives);
    }

    public ISettings getDefaultSettings() {
        return new DungeonSettings(this.base);
    }

    public DungeonSettings getByName(String name) {
        SettingIdentifier id;
        try {
            id = new SettingIdentifier(name);
        }
        catch (Exception e) {
            return null;
        }
        if (!this.settings.contains(id)) {
            return null;
        }
        DungeonSettings setting = new DungeonSettings(this.settings.get(id));
        return SettingsResolver.processInheritance(setting, this.settings);
    }

    public ISettings getWithDefault(SettingIdentifier id) {
        if (!this.settings.contains(id)) {
            return null;
        }
        DungeonSettings setting = new DungeonSettings(this.settings.get(id));
        setting = SettingsResolver.processInheritance(setting, this.settings);
        return new DungeonSettings(this.base, setting);
    }

    public static DungeonSettings processInheritance(DungeonSettings toProcess, SettingsContainer settings) {
        DungeonSettings setting = new DungeonSettings(toProcess);
        for (SettingIdentifier id : toProcess.getInherits()) {
            if (!settings.contains(id)) continue;
            DungeonSettings custom = new DungeonSettings(settings.get(id));
            if (!custom.getInherits().isEmpty()) {
                custom = SettingsResolver.processInheritance(custom, settings);
            }
            setting = new DungeonSettings(custom, setting);
        }
        return setting;
    }

    private DungeonSettings parseFile(String content) throws Exception {
        JsonParser jParser = new JsonParser();
        JsonObject root = null;
        DungeonSettings toAdd = null;
        try {
            root = (JsonObject)jParser.parse(content);
        }
        catch (JsonSyntaxException e) {
            Throwable cause = e.getCause();
            throw new Exception(cause.getMessage());
        }
        catch (Exception e) {
            throw new Exception("An unknown error occurred while parsing json");
        }
        toAdd = new DungeonSettings(root);
        return toAdd;
    }

    private DungeonSettings getBuiltin(IWorldEditor editor, Random rand, Coord pos) {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        for (DungeonSettings setting : this.settings.getBuiltinSettings()) {
            if (!setting.isValid(editor, pos)) continue;
            settingsRandomizer.add(new WeightedChoice<DungeonSettings>(setting, setting.criteria.weight));
        }
        DungeonSettings picked = (DungeonSettings)settingsRandomizer.get(rand);
        return picked;
    }

    private DungeonSettings getCustom(IWorldEditor editor, Random rand, Coord pos) {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        for (DungeonSettings setting : this.settings.getCustomSettings()) {
            if (!setting.isValid(editor, pos) || !setting.isExclusive()) continue;
            settingsRandomizer.add(new WeightedChoice<DungeonSettings>(setting, setting.criteria.weight));
        }
        DungeonSettings chosen = (DungeonSettings)settingsRandomizer.get(rand);
        if (chosen == null) {
            return null;
        }
        return SettingsResolver.processInheritance(chosen, this.settings);
    }

    private DungeonSettings applyInclusives(DungeonSettings setting, IWorldEditor editor, Random rand, Coord pos) {
        DungeonSettings toReturn = new DungeonSettings(setting);
        for (DungeonSettings s : this.settings.getCustomSettings()) {
            if (!s.isValid(editor, pos) || s.isExclusive()) continue;
            toReturn = new DungeonSettings(toReturn, s);
        }
        return toReturn;
    }

    public String toString() {
        return this.settings.toString();
    }
}

