/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SettingsContainer {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String BUILTIN_NAMESPACE = "builtin";
    private Map<String, Map<String, DungeonSettings>> settingsByNamespace = new HashMap<String, Map<String, DungeonSettings>>();

    public void put(DungeonSettings setting) {
        String namespace = setting.getNameSpace() != null ? setting.getNameSpace() : DEFAULT_NAMESPACE;
        String name = setting.getName();
        if (!this.settingsByNamespace.containsKey(namespace)) {
            this.settingsByNamespace.put(namespace, new HashMap());
        }
        Map<String, DungeonSettings> settings = this.settingsByNamespace.get(namespace);
        settings.put(name, setting);
    }

    public Collection<DungeonSettings> getByNamespace(String namespace) {
        if (!this.settingsByNamespace.containsKey(namespace)) {
            return new ArrayList<DungeonSettings>();
        }
        return this.settingsByNamespace.get(namespace).values();
    }

    public Collection<DungeonSettings> getBuiltinSettings() {
        ArrayList<DungeonSettings> settings = new ArrayList<DungeonSettings>();
        for (String namespace : this.settingsByNamespace.keySet()) {
            if (!namespace.equals(BUILTIN_NAMESPACE)) continue;
            settings.addAll(this.settingsByNamespace.get(namespace).values());
        }
        return settings;
    }

    public Collection<DungeonSettings> getCustomSettings() {
        ArrayList<DungeonSettings> settings = new ArrayList<DungeonSettings>();
        for (String namespace : this.settingsByNamespace.keySet()) {
            if (namespace.equals(BUILTIN_NAMESPACE)) continue;
            settings.addAll(this.settingsByNamespace.get(namespace).values());
        }
        return settings;
    }

    public DungeonSettings get(SettingIdentifier id) {
        if (!this.contains(id)) {
            return null;
        }
        Map<String, DungeonSettings> settings = this.settingsByNamespace.get(id.getNamespace());
        return settings.get(id.getName());
    }

    public boolean contains(SettingIdentifier id) {
        if (!this.settingsByNamespace.containsKey(id.getNamespace())) {
            return false;
        }
        Map<String, DungeonSettings> settings = this.settingsByNamespace.get(id.getNamespace());
        return settings.containsKey(id.getName());
    }

    public String toString() {
        String strg = "";
        for (String namespace : this.settingsByNamespace.keySet()) {
            Map<String, DungeonSettings> settings = this.settingsByNamespace.get(namespace);
            for (DungeonSettings setting : settings.values()) {
                strg = strg + setting.id.toString() + " ";
            }
        }
        return strg;
    }
}

