/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

public class SettingIdentifier {
    private String namespace;
    private String name;

    public SettingIdentifier(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public SettingIdentifier(String name) {
        String[] parts = name.split(":");
        if (parts.length > 1) {
            this.namespace = parts[0];
            this.name = parts[1];
            return;
        }
        this.namespace = "default";
        this.name = name;
    }

    public String getNamespace() {
        if (this.namespace == null) {
            return "default";
        }
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        SettingIdentifier other = (SettingIdentifier)o;
        if (this.namespace != other.namespace) {
            return false;
        }
        return this.name == other.name;
    }

    public String toString() {
        return this.getNamespace() + ":" + this.getName();
    }
}

