/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DungeonSettings
implements ISettings {
    public static final int MAX_NUM_LEVELS = 5;
    protected SettingIdentifier id;
    protected List<SettingIdentifier> inherit = new ArrayList<SettingIdentifier>();
    protected boolean exclusive = false;
    protected TowerSettings towerSettings;
    protected Map<Integer, LevelSettings> levels = new HashMap<Integer, LevelSettings>();
    protected SpawnCriteria criteria;
    protected int depth = 0;
    protected LootRuleManager lootRules = new LootRuleManager();
    protected Set<SettingsType> overrides = new HashSet<SettingsType>();

    public DungeonSettings() {
    }

    public DungeonSettings(JsonObject root) throws Exception {
        this();
        if (root.has("namespace")) {
            String name = root.get("name").getAsString();
            String namespace = root.get("namespace").getAsString();
            this.id = new SettingIdentifier(namespace, name);
        } else {
            this.id = new SettingIdentifier(root.get("name").getAsString());
        }
        if (root.has("exclusive")) {
            this.exclusive = root.get("exclusive").getAsBoolean();
        }
        if (root.has("criteria")) {
            this.criteria = new SpawnCriteria(root.get("criteria").getAsJsonObject());
        }
        if (root.has("tower")) {
            this.towerSettings = new TowerSettings(root.get("tower"));
        }
        if (root.has("loot_rules")) {
            this.lootRules = new LootRuleManager(root.get("loot_rules"));
        }
        if (root.has("depth")) {
            int depth = root.get("depth").getAsInt();
            if (depth < 1) {
                this.depth = 1;
            }
            if (depth > 5) {
                this.depth = 5;
            }
            this.depth = depth;
        }
        if (root.has("overrides")) {
            JsonArray overrides = root.get("overrides").getAsJsonArray();
            for (JsonElement e : overrides) {
                String type = e.getAsString();
                this.overrides.add(SettingsType.valueOf(type));
            }
        }
        if (root.has("inherit")) {
            JsonArray inherit = root.get("inherit").getAsJsonArray();
            for (JsonElement e : inherit) {
                this.inherit.add(new SettingIdentifier(e.getAsString()));
            }
        }
        if (!root.has("levels")) {
            return;
        }
        JsonObject levelSet = root.get("levels").getAsJsonObject();
        for (int i = 0; i < 5; ++i) {
            JsonObject data;
            LevelSettings setting = new LevelSettings();
            if (levelSet.has("all")) {
                data = levelSet.get("all").getAsJsonObject();
                setting = new LevelSettings(setting, new LevelSettings(data), this.overrides);
            }
            if (levelSet.has(Integer.toString(i))) {
                data = levelSet.get(Integer.toString(i)).getAsJsonObject();
                setting = new LevelSettings(setting, new LevelSettings(data), this.overrides);
            }
            this.levels.put(i, setting);
        }
    }

    public DungeonSettings(DungeonSettings base, DungeonSettings other) {
        this();
        this.depth = other.depth != 0 ? other.depth : base.depth;
        if (other.overrides != null) {
            this.overrides.addAll(other.overrides);
        }
        this.lootRules = new LootRuleManager();
        if (!this.overrides.contains((Object)SettingsType.LOOTRULES)) {
            this.lootRules.add(base.lootRules);
        }
        this.lootRules.add(other.lootRules);
        for (SettingIdentifier i : other.inherit) {
            this.inherit.add(i);
        }
        this.exclusive = other.exclusive;
        if (this.overrides.contains((Object)SettingsType.TOWER) && other.towerSettings != null) {
            this.towerSettings = new TowerSettings(other.towerSettings);
        } else if (base.towerSettings != null || other.towerSettings != null) {
            this.towerSettings = new TowerSettings(base.towerSettings, other.towerSettings);
        }
        for (int i = 0; i < 5; ++i) {
            this.levels.put(i, new LevelSettings(base.levels.get(i), other.levels.get(i), this.overrides));
        }
    }

    public DungeonSettings(DungeonSettings toCopy) {
        this();
        this.depth = toCopy.depth;
        this.towerSettings = toCopy.towerSettings != null ? new TowerSettings(toCopy.towerSettings) : null;
        this.lootRules = toCopy.lootRules;
        for (SettingIdentifier i : toCopy.inherit) {
            this.inherit.add(i);
        }
        this.exclusive = toCopy.exclusive;
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = toCopy.levels.get(i);
            if (level == null) {
                this.levels.put(i, new LevelSettings());
                continue;
            }
            this.levels.put(i, new LevelSettings(toCopy.levels.get(i)));
        }
        if (toCopy.overrides != null) {
            this.overrides.addAll(toCopy.overrides);
        }
    }

    @Override
    public List<SettingIdentifier> getInherits() {
        return this.inherit;
    }

    public String getNameSpace() {
        return this.id.getNamespace();
    }

    public String getName() {
        return this.id.getName();
    }

    public void setCriteria(SpawnCriteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean isValid(IWorldEditor editor, Coord pos) {
        if (this.criteria == null) {
            this.criteria = new SpawnCriteria();
        }
        return this.criteria.isValid(editor, pos);
    }

    @Override
    public LevelSettings getLevelSettings(int level) {
        return this.levels.get(level);
    }

    @Override
    public TowerSettings getTower() {
        if (this.towerSettings == null) {
            return new TowerSettings(Tower.ROGUE, Theme.getTheme(Theme.PURPUR));
        }
        return this.towerSettings;
    }

    @Override
    public int getNumLevels() {
        if (this.depth < 0) {
            return 0;
        }
        if (this.depth > 5) {
            return 5;
        }
        return this.depth;
    }

    @Override
    public LootRuleManager getLootRules() {
        return this.lootRules;
    }

    @Override
    public Set<SettingsType> getOverrides() {
        return this.overrides;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }
}

