/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.dungeon.base.ISecretRoom;
import greymerk.roguelike.dungeon.base.SecretRoom;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SecretFactory {
    private Map<DungeonRoom, ISecretRoom> secrets = new HashMap<DungeonRoom, ISecretRoom>();

    public SecretFactory() {
    }

    public SecretFactory(SecretFactory toCopy) {
        this();
        for (DungeonRoom type : toCopy.secrets.keySet()) {
            int count = toCopy.secrets.get((Object)type).getCount();
            this.addRoom(type, count);
        }
    }

    public SecretFactory(SecretFactory base, SecretFactory other) {
        this();
        int count;
        if (base != null) {
            for (DungeonRoom type : base.secrets.keySet()) {
                count = base.secrets.get((Object)type).getCount();
                this.addRoom(type, count);
            }
        }
        if (other != null) {
            for (DungeonRoom type : other.secrets.keySet()) {
                count = other.secrets.get((Object)type).getCount();
                this.addRoom(type, count);
            }
        }
    }

    public SecretFactory(JsonArray data) {
        this();
        for (JsonElement e : data) {
            JsonObject room = e.getAsJsonObject();
            String type = room.get("type").getAsString();
            int num = room.get("num").getAsInt();
            this.addRoom(DungeonRoom.valueOf(type), num);
        }
    }

    public void addRoom(DungeonRoom type) {
        this.addRoom(type, 1);
    }

    public void addRoom(DungeonRoom type, int count) {
        if (this.secrets.containsKey((Object)type)) {
            ISecretRoom room = this.secrets.get((Object)type);
            room.add(count);
            return;
        }
        SecretRoom room = new SecretRoom(type, count);
        this.secrets.put(type, room);
    }

    public IDungeonRoom genRoom(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord pos) {
        for (ISecretRoom room : this.secrets.values()) {
            IDungeonRoom generated = room.genRoom(editor, rand, settings, dir, pos);
            if (generated == null) continue;
            return generated;
        }
        return null;
    }

    public boolean equals(Object o) {
        SecretFactory other = (SecretFactory)o;
        if (!this.secrets.keySet().equals(other.secrets.keySet())) {
            return false;
        }
        for (DungeonRoom type : this.secrets.keySet()) {
            if (this.secrets.get((Object)type).equals(other.secrets.get((Object)type))) continue;
            return false;
        }
        return true;
    }
}

