/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonFactory;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DungeonFactory
implements IDungeonFactory {
    private Map<DungeonRoom, Integer> singles = new HashMap<DungeonRoom, Integer>();
    private Map<DungeonRoom, Integer> multiple = new HashMap<DungeonRoom, Integer>();
    private DungeonRoom base;

    public DungeonFactory() {
        this(DungeonRoom.CORNER);
    }

    public DungeonFactory(DungeonRoom base) {
        this.base = base;
    }

    public DungeonFactory(JsonArray json) throws Exception {
        this();
        for (JsonElement e : json) {
            JsonObject entry = e.getAsJsonObject();
            String mode = entry.get("mode").getAsString().toLowerCase();
            String type = entry.get("type").getAsString().toUpperCase();
            if (!DungeonRoom.contains(type)) {
                throw new Exception("No such dungeon: " + type);
            }
            DungeonRoom toAdd = DungeonRoom.valueOf(entry.get("type").getAsString());
            if (mode.equals("single")) {
                this.addSingle(toAdd);
            }
            if (!mode.equals("random")) continue;
            this.addRandom(toAdd, entry.get("weight").getAsInt());
        }
    }

    public DungeonFactory(DungeonFactory toCopy) {
        this();
        for (DungeonRoom room : toCopy.singles.keySet()) {
            this.singles.put(room, toCopy.singles.get((Object)room));
        }
        for (DungeonRoom room : toCopy.multiple.keySet()) {
            this.multiple.put(room, toCopy.multiple.get((Object)room));
        }
        this.base = toCopy.base;
    }

    public DungeonFactory(DungeonFactory base, DungeonFactory other) {
        this();
        this.base = other.base;
        for (DungeonRoom room : base.singles.keySet()) {
            this.singles.put(room, base.singles.get((Object)room));
        }
        for (DungeonRoom room : base.multiple.keySet()) {
            this.multiple.put(room, base.multiple.get((Object)room));
        }
        for (DungeonRoom room : other.singles.keySet()) {
            this.singles.put(room, other.singles.get((Object)room));
        }
        for (DungeonRoom room : other.multiple.keySet()) {
            this.multiple.put(room, other.multiple.get((Object)room));
        }
    }

    public void addSingle(DungeonRoom type) {
        this.addSingle(type, 1);
    }

    public void addSingle(DungeonRoom type, int num) {
        if (!this.singles.containsKey((Object)type)) {
            this.singles.put(type, num);
            return;
        }
        int count = this.singles.get((Object)type);
        this.singles.put(type, count += num);
    }

    public void addRandom(DungeonRoom type, int weight) {
        this.multiple.put(type, weight);
    }

    @Override
    public IDungeonRoom get(Random rand) {
        if (!this.singles.isEmpty()) {
            return this.getSingle(rand);
        }
        if (!this.multiple.isEmpty()) {
            return this.getRandom(rand);
        }
        return DungeonRoom.getInstance(this.base);
    }

    private IDungeonRoom getRandom(Random rand) {
        Set<DungeonRoom> keyset = this.multiple.keySet();
        if (keyset.isEmpty()) {
            return null;
        }
        WeightedRandomizer<DungeonRoom> randomizer = new WeightedRandomizer<DungeonRoom>();
        for (DungeonRoom room : keyset) {
            randomizer.add(new WeightedChoice<DungeonRoom>(room, this.multiple.get((Object)room)));
        }
        DungeonRoom choice = (DungeonRoom)((Object)randomizer.get(rand));
        return DungeonRoom.getInstance(choice);
    }

    private IDungeonRoom getSingle(Random rand) {
        Set<DungeonRoom> keyset = this.singles.keySet();
        if (keyset.isEmpty()) {
            return null;
        }
        DungeonRoom[] rooms = keyset.toArray(new DungeonRoom[0]);
        DungeonRoom type = rooms[rand.nextInt(rooms.length)];
        if (this.singles.get((Object)type) <= 1) {
            this.singles.remove((Object)type);
        } else {
            this.singles.put(type, this.singles.get((Object)type) - 1);
        }
        return DungeonRoom.getInstance(type);
    }

    public boolean equals(Object o) {
        DungeonFactory other = (DungeonFactory)o;
        if (!this.base.equals((Object)other.base)) {
            return false;
        }
        if (!this.singles.equals(other.singles)) {
            return false;
        }
        return this.multiple.equals(other.multiple);
    }
}

