/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.util.mst.Edge;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.util.mst.Point;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LevelGeneratorMST
implements ILevelGenerator {
    IWorldEditor editor;
    Random rand;
    IDungeonLevel level;
    private DungeonNode end;
    private List<DungeonNode> nodes;
    private List<DungeonTunnel> tunnels;

    public LevelGeneratorMST(IWorldEditor editor, Random rand, IDungeonLevel level) {
        this.editor = editor;
        this.rand = rand;
        this.level = level;
        this.nodes = new ArrayList<DungeonNode>();
        this.tunnels = new ArrayList<DungeonTunnel>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(Coord start, DungeonNode oldEnd) {
        IDungeonRoom toGenerate;
        void var8_11;
        MinimumSpanningTree mst = new MinimumSpanningTree(this.rand, 7, 17, new Coord(start));
        List<Edge> edges = mst.getEdges();
        List<Coord> vertices = mst.getPointPositions();
        ArrayList<Edge> used = new ArrayList<Edge>();
        for (Coord coord : vertices) {
            for (Edge e : edges) {
                Point[] ends;
                if (used.contains(e)) continue;
                for (Point p : ends = e.getPoints()) {
                    if (!p.getPosition().equals(coord)) continue;
                    Cardinal dir = this.getDirection(ends, p);
                    Coord tStart = ends[0].getPosition();
                    Coord tEnd = ends[1].getPosition();
                    this.tunnels.add(new DungeonTunnel(this.editor, tStart, tEnd, dir));
                    used.add(e);
                }
            }
        }
        DungeonNode startDungeonNode = null;
        for (Coord c : vertices) {
            ArrayList<Cardinal> entrances = new ArrayList<Cardinal>();
            for (DungeonTunnel tunnel : this.tunnels) {
                Coord[] ends = tunnel.getEnds();
                if (ends[0].equals(c)) {
                    entrances.add(tunnel.getDirection());
                    continue;
                }
                if (!ends[1].equals(c)) continue;
                entrances.add(Cardinal.reverse(tunnel.getDirection()));
            }
            Cardinal[] ents = new Cardinal[entrances.size()];
            DungeonNode toAdd = new DungeonNode(entrances.toArray(ents), c);
            this.nodes.add(toAdd);
            if (!c.equals(start)) continue;
            startDungeonNode = toAdd;
        }
        boolean bl = false;
        do {
            this.end = this.nodes.get(this.rand.nextInt(this.nodes.size()));
        } while (this.end == startDungeonNode || this.end.getPosition().distance(start) > (double)(16 + ++var8_11 * 2));
        for (DungeonNode node : this.nodes) {
            if (node == this.end || node == startDungeonNode) continue;
            toGenerate = this.level.getSettings().getRooms().get(this.rand);
            node.setDungeon(toGenerate);
        }
        if (RogueConfig.getBoolean(RogueConfig.ENCASE)) {
            for (DungeonNode node : this.nodes) {
                if (node == this.end || node == startDungeonNode) continue;
                node.encase(this.editor, this.rand, this.level.getSettings().getTheme());
            }
            for (DungeonTunnel t : this.getTunnels()) {
                t.encase(this.editor, this.rand, this.level.getSettings().getTheme());
            }
        }
        for (DungeonTunnel t : this.getTunnels()) {
            t.construct(this.editor, this.rand, this.level.getSettings());
        }
        for (DungeonNode node : this.nodes) {
            if (node == this.end || node == startDungeonNode) continue;
            toGenerate = node.getRoom();
            toGenerate.generate(this.editor, this.rand, this.level.getSettings(), node.getEntrances(), node.getPosition());
        }
        for (DungeonTunnel tunnel : this.getTunnels()) {
            tunnel.genSegments(this.editor, this.rand, this.level);
        }
        LevelGenerator.generateLevelLink(this.editor, this.rand, this.level.getSettings(), start, oldEnd);
    }

    @Override
    public DungeonNode getEnd() {
        return this.end;
    }

    private Cardinal getDirection(Point[] ends, Point p) {
        Coord c2;
        Coord c1;
        if (p.getPosition().equals(ends[0].getPosition())) {
            c1 = ends[0].getPosition();
            c2 = ends[1].getPosition();
        } else {
            c1 = ends[1].getPosition();
            c2 = ends[0].getPosition();
        }
        if (c2.getX() - c1.getX() == 0) {
            if (c2.getZ() - c1.getZ() < 0) {
                return Cardinal.NORTH;
            }
            return Cardinal.SOUTH;
        }
        if (c2.getX() - c1.getX() < 0) {
            return Cardinal.WEST;
        }
        return Cardinal.EAST;
    }

    @Override
    public List<DungeonNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<DungeonTunnel> getTunnels() {
        return this.tunnels;
    }
}

