/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.citadel;

import greymerk.roguelike.citadel.Citadel;
import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.util.mst.Edge;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import java.util.Random;

public class CityGrounds {
    public static void generate(IWorldEditor editor, Random rand, MinimumSpanningTree mst, ITheme theme, Coord pos) {
        Coord start = new Coord(pos);
        start.add(new Coord(-51, 10, -51));
        Coord end = new Coord(pos);
        end.add(new Coord(51, 40, 51));
        RectSolid.fill(editor, rand, start, end, BlockType.get(BlockType.AIR), true, true);
        start = new Coord(pos);
        start.add(new Coord(-51, 10, -51));
        end = new Coord(pos);
        end.add(new Coord(51, 20, 51));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        start = new Coord(pos);
        start.add(new Coord(-34, 20, -34));
        end = new Coord(pos);
        end.add(new Coord(34, 30, 34));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        start = new Coord(pos);
        start.add(new Coord(-17, 30, -17));
        end = new Coord(pos);
        end.add(new Coord(17, 40, 17));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        Coord cursor = new Coord(pos);
        cursor.add(Cardinal.UP, 20);
        for (Edge e : mst.getEdges()) {
            start = e.getPoints()[0].getPosition();
            start.add(cursor);
            end = e.getPoints()[1].getPosition();
            end.add(cursor);
            end.add(Cardinal.DOWN, 20);
            RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        }
        List<Coord> towers = mst.getPointPositions();
        for (Coord c : towers) {
            c.add(pos);
            rand = Citadel.getRandom(editor, c.getX(), c.getZ());
            ITower tower = Tower.get(Tower.values()[rand.nextInt(Tower.values().length)]);
            tower.generate(editor, rand, Theme.getTheme(Theme.values()[rand.nextInt(Theme.values().length)]), new Coord(c.getX(), 50, c.getZ()));
        }
    }
}

