/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.draconicevolution.items.tools.CollectorCallBack;
import com.brandon3055.draconicevolution.items.tools.WyvernAxe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TreeCollector {
    private World world;
    private boolean breakDown;
    private int connectionRadius;
    private ItemStack stack;
    private EntityPlayer player;
    private WyvernAxe axe;
    private boolean collectionComplete = false;
    private boolean isKilled = false;
    private List<IProcess> activeProcesses = new ArrayList<IProcess>();
    private InventoryDynamic inventory = new InventoryDynamic();
    private CollectorCallBack collectionCallback = null;
    public int collected = 0;
    public int energyUsed = 0;

    public TreeCollector(World world, boolean breakDown, int connectionRadius, ItemStack stack, EntityPlayer player, WyvernAxe axe) {
        this.world = world;
        this.breakDown = breakDown;
        this.connectionRadius = connectionRadius;
        this.stack = stack;
        this.player = player;
        this.axe = axe;
    }

    public void collectTree(BlockPos startPos) {
        CollectTreeProcess process = new CollectTreeProcess(this, startPos, this.inventory, new ArrayList<BlockPos>());
        ProcessHandler.addProcess((IProcess)process);
    }

    public void killCollector() {
        this.isKilled = true;
    }

    public void clearCollected() {
        this.collectionComplete = false;
        this.isKilled = false;
        this.inventory.func_174888_l();
        this.collected = 0;
    }

    public boolean isCollectionComplete() {
        return this.collectionComplete;
    }

    public InventoryDynamic getCollected() {
        return this.inventory;
    }

    public void setCollectionCallback(CollectorCallBack collectionCallback) {
        this.collectionCallback = collectionCallback;
    }

    public static class CollectTreeProcess
    implements IProcess {
        private TreeCollector collector;
        private final World world;
        private final BlockPos pos;
        private InventoryDynamic inventory;
        private final List<BlockPos> processedBlocks;
        private boolean isDead = false;
        private int ticks = 0;
        private double randOffset = 0.0;

        public CollectTreeProcess(TreeCollector selector, BlockPos pos, InventoryDynamic inventory, List<BlockPos> processedBlocks) {
            this.collector = selector;
            this.world = selector.world;
            this.pos = pos;
            this.inventory = inventory;
            this.processedBlocks = processedBlocks;
            selector.activeProcesses.add(this);
            this.randOffset = 0.5 + ((TreeCollector)selector).world.field_73012_v.nextDouble() * 0.5;
        }

        public void updateProcess() {
            int xp;
            if ((double)this.ticks < (double)(this.collector.activeProcesses.size() / 2) * this.randOffset) {
                ++this.ticks;
                return;
            }
            if (this.collector.isKilled) {
                this.isDead = true;
                this.collector.activeProcesses.remove(this);
                if (this.collector.activeProcesses.size() == 0) {
                    this.collector.collectionComplete = true;
                }
                return;
            }
            if (this.collector.axe.getEnergyStored(this.collector.stack) - this.collector.energyUsed < ((TreeCollector)this.collector).axe.energyPerOperation && !((TreeCollector)this.collector).player.field_71075_bZ.field_75098_d) {
                this.isDead = true;
                return;
            }
            IBlockState state = this.world.func_180495_p(this.pos);
            if (!ForgeHooks.canHarvestBlock((Block)state.func_177230_c(), (EntityPlayer)this.collector.player, (IBlockAccess)this.world, (BlockPos)this.pos)) {
                this.isDead = true;
                return;
            }
            if (this.collector.collectionCallback != null) {
                this.collector.collectionCallback.call(this.pos);
            }
            if ((xp = ForgeHooks.onBlockBreakEvent((World)this.world, (GameType)((EntityPlayerMP)((TreeCollector)this.collector).player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)this.collector.player), (BlockPos)this.pos)) == -1) {
                this.isDead = true;
                return;
            }
            this.inventory.xp += xp;
            this.collector.energyUsed += ((TreeCollector)this.collector).axe.energyPerOperation;
            this.world.func_175718_b(2001, this.pos, Block.func_176210_f((IBlockState)state));
            BlockToStackHelper.breakAndCollect((World)this.world, (BlockPos)this.pos, (InventoryDynamic)this.inventory, (int)xp);
            ++this.collector.collected;
            int rad = this.collector.connectionRadius;
            Iterable blocks = BlockPos.func_177980_a((BlockPos)this.pos.func_177982_a(-rad, this.collector.breakDown ? -rad : 0, -rad), (BlockPos)this.pos.func_177982_a(rad, rad, rad));
            for (BlockPos newPos : blocks) {
                if (this.processedBlocks.contains(newPos)) continue;
                this.processedBlocks.add(newPos);
                IBlockState newState = this.world.func_180495_p(newPos);
                if (!newState.func_177230_c().isWood((IBlockAccess)this.world, newPos)) continue;
                ProcessHandler.addProcess((IProcess)new CollectTreeProcess(this.collector, newPos, this.inventory, this.processedBlocks));
            }
            this.isDead = true;
            this.collector.activeProcesses.remove(this);
            if (this.collector.activeProcesses.size() == 0) {
                this.collector.collectionComplete = true;
            }
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

