/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCOBJParser;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateManagerHelper;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderTileReactorCore
extends TESRBase<TileReactorCore> {
    private CCModel model;

    public RenderTileReactorCore() {
        Map map = CCOBJParser.parseObjModels((ResourceLocation)ResourceHelperDE.getResource("models/block/obj_models/reactor_core.obj"));
        this.model = CCModel.combine(map.values());
    }

    public void renderTileEntityAt(TileReactorCore te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.func_179094_E();
        GlStateManagerHelper.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(200.0f);
        float scale = 2.0f;
        float intensity = 0.0f;
        float animation = ((float)ClientEventHandler.elapsedTicks + partialTicks) / 50.0f;
        if (MinecraftForgeClient.getRenderPass() == 0) {
            this.renderCore(x, y, z, partialTicks, intensity, animation, scale, DEShaders.useShaders());
        } else {
            this.renderShield(x, y, z, partialTicks, intensity, scale, DEShaders.useShaders());
        }
        this.resetLighting();
        GlStateManagerHelper.popState();
        GlStateManager.func_179121_F();
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        GlStateManagerHelper.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(200.0f);
        float scale = 1.5f;
        float intensity = 0.0f;
        this.renderCore(0.0, 0.0, 0.0, 0.0f, intensity, 0.0f, scale, DEShaders.useShaders());
        this.resetLighting();
        GlStateManagerHelper.popState();
        GlStateManager.func_179121_F();
    }

    private void renderCore(double x, double y, double z, float partialTicks, float intensity, float animation, float scale, boolean useShader) {
        ResourceHelperDE.bindTexture("textures/models/reactor_core.png");
        if (useShader) {
            DEShaders.reactorOp.setIntensity(intensity);
            DEShaders.reactorOp.setAnimation(animation);
            DEShaders.reactor.freeBindShader();
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)scale);
        this.model.render(ccrs, new IVertexOperation[]{mat});
        ccrs.draw();
        if (useShader) {
            ShaderProgram.unbindShader();
        }
    }

    private void renderShield(double x, double y, double z, float partialTicks, float intensity, float scale, boolean useShader) {
        ResourceHelperDE.bindTexture("textures/models/reactor_shield.png");
        if (useShader) {
            DEShaders.reactorOp.setIntensity(intensity);
            DEShaders.reactorShield.freeBindShader();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0), (double)((double)scale * 1.05));
        this.model.render(ccrs, new IVertexOperation[]{mat});
        ccrs.draw();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (useShader) {
            ShaderProgram.unbindShader();
        }
    }
}

