/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.shaders;

import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.pipeline.CCShaderPipeline;
import codechicken.lib.render.shader.pipeline.attribute.IShaderOperation;
import com.brandon3055.draconicevolution.DEConfig;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public class DEShaders {
    public static int reactorOpID;
    public static ShaderProgram reactor;
    public static ShaderProgram reactorShield;
    public static ReactorOperation reactorOp;
    public static int crystalOpID;
    public static ShaderProgram energyCrystal;
    public static ECrystalOperation eCrystalOp;

    public static void initReactorShader() {
        if (reactor != null) {
            reactor.cleanup();
        }
        reactorOpID = CCShaderPipeline.registerOperation();
        reactor = new ShaderProgram();
        reactor.attachFrag("/assets/draconicevolution/shaders/reactor.frag");
        reactorOp = new ReactorOperation();
        reactor.attachShaderOperation((IShaderOperation)reactorOp);
        reactor.validate();
    }

    public static void initReactorShieldShader() {
        if (reactorShield != null) {
            reactorShield.cleanup();
        }
        reactorShield = new ShaderProgram();
        reactorShield.attachFrag("/assets/draconicevolution/shaders/reactor_shield.frag");
        reactorShield.attachShaderOperation((IShaderOperation)reactorOp);
        reactorShield.validate();
    }

    public static void initEnergyCrystalShader() {
        if (energyCrystal != null) {
            energyCrystal.cleanup();
        }
        crystalOpID = CCShaderPipeline.registerOperation();
        energyCrystal = new ShaderProgram();
        energyCrystal.attachFrag("/assets/draconicevolution/shaders/energy_crystal.frag");
        energyCrystal.attachVert("/assets/draconicevolution/shaders/energy_crystal.vert");
        eCrystalOp = new ECrystalOperation();
        energyCrystal.attachShaderOperation((IShaderOperation)eCrystalOp);
        energyCrystal.validate();
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g && DEConfig.useShaders;
    }

    static {
        DEShaders.initReactorShader();
        DEShaders.initReactorShieldShader();
        DEShaders.initEnergyCrystalShader();
    }

    public static class ECrystalOperation
    implements IShaderOperation {
        public int type = 0;
        public float animation = 0.0f;
        public float angleX = 0.0f;
        public float angleY = 0.0f;
        public float mipmap = 1.0f;
        private final TObjectFloatHashMap<ShaderProgram> timeCache = new TObjectFloatHashMap();
        private final TObjectFloatHashMap<ShaderProgram> mipmapCache = new TObjectFloatHashMap();
        private final TObjectIntHashMap<ShaderProgram> typeCache = new TObjectIntHashMap();
        private final TObjectFloatHashMap<ShaderProgram> angleCache = new TObjectFloatHashMap();

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            if (this.animation != this.timeCache.get((Object)program)) {
                int time = program.getUniformLoc("time");
                ARBShaderObjects.glUniform1fARB((int)time, (float)this.animation);
                this.timeCache.put((Object)program, this.animation);
            }
            if (this.mipmap != this.mipmapCache.get((Object)program)) {
                int mipmap = program.getUniformLoc("mipmap");
                ARBShaderObjects.glUniform1fARB((int)mipmap, (float)this.mipmap);
                this.mipmapCache.put((Object)program, this.mipmap);
            }
            if (this.type != this.typeCache.get((Object)program)) {
                int type = program.getUniformLoc("type");
                ARBShaderObjects.glUniform1iARB((int)type, (int)this.type);
                this.typeCache.put((Object)program, this.type);
            }
            if (this.angleX * this.angleY != this.angleCache.get((Object)program)) {
                int angle = program.getUniformLoc("angle");
                ARBShaderObjects.glUniform2fARB((int)angle, (float)this.angleX, (float)this.angleY);
                this.angleCache.put((Object)program, this.angleX * this.angleY);
            }
        }

        public int operationID() {
            return crystalOpID;
        }

        public void setAnimation(float animation) {
            this.animation = animation;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setAngle(float angleX, float angleY) {
            this.angleX = angleX;
            this.angleY = angleY;
        }

        public void setMipmap(float mipmap) {
            this.mipmap = mipmap;
        }
    }

    public static class ReactorOperation
    implements IShaderOperation {
        public float intensity = 0.0f;
        public float animation = 0.0f;

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            int time = program.getUniformLoc("time");
            ARBShaderObjects.glUniform1fARB((int)time, (float)this.animation);
            int intensity = program.getUniformLoc("intensity");
            ARBShaderObjects.glUniform1fARB((int)intensity, (float)this.intensity);
        }

        public int operationID() {
            return reactorOpID;
        }

        public void setAnimation(float animation) {
            this.animation = animation;
        }

        public void setIntensity(float intensity) {
            this.intensity = intensity;
        }
    }
}

